<?php

namespace App\Http\Controllers;
use Exception;
use App\Models\BrokerParty;
use App\Http\Resources\BrokerPartyResources;
use Illuminate\Http\Request;

class BrokerPartyController extends Controller
{
    public function index(Request $request)
    {
        try{
            return BrokerPartyResources::collection(BrokerParty::where('customer',$request->user()->id)->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }

    public function store(Request $request)
    {
        try{
            $data = $request->isMethod('put') ? BrokerParty::findOrFail($request->id) : new BrokerParty();
            $data->id = $request->input('id');
            $data->name = $request->name;
            $data->location = $request->location;
            $data->customer = $request->user()->id;
            $data->save();
            $message = $request->isMethod('put') ? response()->json(['action' => true, 'message' => "Party has been updated"]) :
            response()->json(['action' => true, 'message' => "Party has been Created"]);
            return $message;
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }

    public function show($id)
    {
        try{
            return New BrokerPartyResources(BrokerParty::findOrFail($id));
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
}
