<?php

namespace App\Http\Controllers;
use App\Http\Controllers\SmsController;
use App\Models\DailyUpdate;
use App\Models\User;
use App\Http\Resources\DailyUpdateBackend;
use App\Notifications\UpdateNotification;
use Exception;
use Illuminate\Http\Request;
use App\Events\UpdateEvent;

use GuzzleHttp\Exception\GuzzleException;
use GuzzleHttp\Client;

class DailyUpdateController extends Controller
{
    private $SMS;
    public function __construct()
    {
        $this->SMS = new SmsController();
    }
    public function index()
    {
        try{
            return DailyUpdateBackend::collection(DailyUpdate::all());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }

    public function store(Request $request)
    {
       // try{
            $data = $request->isMethod('put') ? DailyUpdate::findOrFail($request->id) : new DailyUpdate();
            $data->id = $request->input('id');
            $data->product = $request->product;
            $data->conditionRate = $request->conditionRate;
            $data->nonConditionRate = $request->nonConditionRate;
            $data->readyRate = $request->readyRate;
            $data->forwardRate = $request->forwardRate;
            $data->looseRatePbHr = $request->looseRatePbHr;
            $data->looseRateSumerpur = $request->looseRateSumerpur;
            $data->readyLiftingIn = $request->readyLiftingIn;
            $data->forwardLiftingIn = $request->forwardLiftingIn;
            $data->forForwardCday = $request->forForwardCday;
            $data->forReadyCday = $request->forReadyCday;
            $data->generatedBy = $request->user()->id;
            $data->save();
            $CurrentData = Http::withHeaders([
                'Accept' => 'application/json',
                'Authorization' => $request->header('Authorization'),
                ])->get(route('singleupdate', ['id' => $data->id]));

            if(($request->conditionRate != 0 || $request->nonConditionRate != 0 || $request->readyRate != 0 || $request->forwardRate != 0 || $request->looseRatePbHr != 0 || $request->looseRateSumerpur != '') && ($request->conditionRate != '' || $request->nonConditionRate != '' || $request->readyRate != '' || $request->forwardRate != '' || $request->looseRatePbHr != '' || $request->looseRateSumerpur != '') && ($request->conditionRate != NULL || $request->nonConditionRate != NULL || $request->readyRate != NULL || $request->forwardRate != NULL || $request->looseRatePbHr != NULL || $request->looseRateSumerpur != NULL)){
                $sendmsgtousers = User::whereRaw("find_in_set($request->product,product)")->where(function ($q) { $q->where('status', 1)->whereIn('role', ['customer','broker']); })->pluck('phone')->toArray();
                $sendNumber = implode(', ',$sendmsgtousers);
                //return $sendNumber;
                $this->SMS->sendSMS($sendNumber,json_decode((string) $CurrentData->getBody(),true),false,'update');
            }
                $user = User::whereRaw("find_in_set($request->product,product)")->where(function ($q) { $q->where('status', 1)->whereIn('role', ['customer','broker']); })->get();
                foreach($user as $u):
                    $u->notify(new UpdateNotification($data));
                endforeach;
            $message = $request->isMethod('put') ? response()->json(['action' => true, 'message' => "Daily Sales & Purchase has been updated"]) :
            response()->json(['action' => true, 'message' => "Sale has been Genrated"]);
            return $message;
        //}catch(Exception $error){
        //    return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
       // }
    }

    public function show($id)
    {
        try{
            return New DailyUpdateBackend(DailyUpdate::findOrFail($id));
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showbyLocation($location,$id)
    {
        //try{
            $data = DailyUpdate::findOrFail($id);
            $data['locationId'] = $location;
            return New DailyUpdateBackend($data);
        //}catch(Exception $error){
           // return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
       // }
    }


    public function destroy($id)
    {
        try{
            $del = New DailyUpdate();
            $del->whereIn('id',explode(",",$id))->delete();
            return response()->json(['action' => true, 'message' => "Selected Sales has been deleted"]);
         }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
         }
    }
}
