<?php

namespace App\Http\Controllers;
use App\Models\User;
use App\Models\DailyUpdate;
use App\Models\Product;
use Exception;
use App\Models\Order;
use App\Http\Resources\DashboardBackend;
use App\Http\Resources\CustmorDahsboard;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function BackendDahsboard(Request $request){
        $user = explode(',', $request->user()->product);
        $product = Product::whereIn('id',$user)->orderBy('productOrder','asc')->get();
        $array = Array();
        foreach($product as $u):
            $data = DailyUpdate::where('product',$u->id)->orderBy('created_at', 'desc')->first();
            $array[] = new DashboardBackend($data);
        endforeach;
        return response()->json($array);

    }
    public function BackendDahsboardByLocation(Request $request, $location){
        $user = explode(',', $request->user()->product);
        $product = Product::whereIn('id',$user)->orderBy('productOrder','asc')->get();
        $array = Array();
        foreach($product as $u):
            $data = DailyUpdate::where('product',$u->id)->orderBy('created_at', 'desc')->first();
            $data['locationId'] = $location;
            $array[] = new DashboardBackend($data);
        endforeach;
        return response()->json($array);

    }

    public function CustmorDahsboard(Request $request){
        $user = explode(',', $request->user()->product);
        $product = Product::whereIn('id',$user)->orderBy('productOrder','asc')->get();
        $array = Array();
        foreach($product as $u):
            $data = DailyUpdate::where('product',$u->id)->orderBy('created_at', 'desc')->first();
            $array[] = new CustmorDahsboard($data);
        endforeach;
        return response()->json($array);

    }public function CustmorDahsboardByLocation(Request $request, $location){
        $user = explode(',', $request->user()->product);
        $product = Product::whereIn('id',$user)->orderBy('productOrder','asc')->get();
        $array = Array();
        foreach($product as $u):
            $data = DailyUpdate::where('product',$u->id)->orderBy('created_at', 'desc')->first();
            $data['locationId'] = $location;
            $array[] = new CustmorDahsboard($data);
        endforeach;
        return response()->json($array);

    }

    public function CustmorCounterApproved(Request $request ){
        try{
            return response()->json(Order::where('customer', $request->user()->id)->where('status','approved')->count());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function CustmorCounterPending(Request $request){
        try{
            return response()->json(Order::where('customer', $request->user()->id)->where('status','pending')->count());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function CustmorCounterSubmitted(Request $request){
        try{
            return response()->json(Order::where('customer', $request->user()->id)->count());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function CustmorCounterNotApproved(Request $request){
        try{
            return response()->json(Order::where('customer', $request->user()->id)->where('status','notapproved')->count());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }




    public function BackendCounterApproved(){
        try{
            return response()->json(Order::where('status','approved')->count());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function BackendCounterPending(){
        try{
            return response()->json(Order::where('status','pending')->count());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function BackendCounterSubmitted(){
        try{
            return response()->json(Order::all()->count());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function BackendCounterNotApproved(){
        try{
            return response()->json(Order::where('status','notapproved')->count());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }

}
