<?php

namespace App\Http\Controllers;
use Exception;
use App\Models\Location;
use Illuminate\Http\Request;
use App\Http\Resources\LocationResources;

class LocationController extends Controller
{
    public function index()
    {
        return LocationResources::collection(Location::all());
    }
    public function indexActive()
    {
        return LocationResources::collection(Location::where('status',1)->get());
    }
    public function store(Request $request)
    {
        $data = $request->isMethod('put') ? Location::findOrFail($request->id) : new Location();
        $data->id = $request->id;
        $data->location = $request->location;
        $data->freight = $request->freight;
        $data->gst = $request->gst;
        $data->loadingCarges = $request->loadingCarges;
        $data->interest = $request->interest;
        $data->other = $request->other;
        $data->status = $request->status;
        $data->isDefault = $request->isDefault;
        $data->manageBy = $request->user()->id;
        $data->save();

        $message = $request->isMethod('put') ? response()->json(['action' => true, 'message' => "Location data has been updated"]) :
            response()->json(['action' => true, 'message' => "New location has been created"]);
            return $message;
    }
    public function show($id)
    {
        try{
            return  New LocationResources(Location::findOrFail($id));
         }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
         }
    }
    public function destroy($id)
    {
        try{
            $del = New Location();
            $del->whereIn('id',explode(",",$id))->delete();
            return response()->json(['action' => true, 'message' => "Selectd locations has been deleted"]);
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
}
