<?php

namespace App\Http\Controllers;
use Exception;
use App\Models\Order;
use App\Models\User;
use App\Http\Controllers\SmsController;
use App\Http\Controllers\MailController;
use Illuminate\Support\Facades\Auth;
use App\Notifications\UpdateNotification;
use App\Notifications\NewOrderNotification;
use App\Notifications\FinalUpdateNotification;
use App\Notifications\ApprovedNotification;
use App\Models\Product;
use Illuminate\Http\Request;
use App\Http\Resources\PurchaseFormA;
use App\Http\Resources\PurchaseFormB;
use App\Http\Resources\PurchaseFormC;
use App\Http\Resources\SaleFormA;
use App\Http\Resources\SaleFormB;
use Illuminate\Support\Facades\Validator;

class OrderController extends Controller
{
    private $SMS;
    private $MAIL;
    public function __construct()
    {
        $this->SMS = new SmsController();
        $this->MAIL = new MailController();
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
         return PurchaseFormA::collection(Order::all());
    }
    public function openOrder($id){
       // try{
            $data = Order::where('product', $id)->update(['open' => 'open']);
            return response()->json(['action' => true, 'message' => "open"]);
      //  }catch(Exception $error){
      //      return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
       // }
        
        
    }
    public function makenap(){
        try{
            $date = new \DateTime();
            $date->modify('-3 hours');
            $formatted_date = $date->format('Y-m-d H:i:s');
            Order::where('updated_at', '>', $formatted_date)->where('status','pending')->update(['status' => 'notapproved']);
            return response()->json(['action' => true, 'message' => "updated"]);
        }catch(Exception $error){
             return response()->json(['action' => false, 'message' => "Somthing wrong!", 'error' => $error]);
        }
        
    }
    public function create(Request $request){
        //try{
           // return response()->json(['action' => false, 'message' => $request->katta]);
            $date = new \DateTime();
            $date->modify('24 hours');
            $newDate = $date->format('Y-m-d');
            
            $validatedData = $request->validate([
                'oRate' => 'required',
                'oQty' => 'required',
            ]);
            $data = $request->isMethod('put') ? Order::findOrFail($request->id) : new Order();
            $data->dRate = $request->dRate;
            $data->oRate = $request->oRate;
            $data->oQty = $request->oQty;
            $data->oPaymentDate = $request->oPaymentDate == "" || $request->oPaymentDate == null ? $newDate : $request->oPaymentDate;
            $data->oLoadingDate = $request->oLoadingDate == "" || $request->oLoadingDate == null ? $newDate : $request->oLoadingDate;
            $data->paymentCond = $request->paymentCond;
            $data->oBag = $request->oBag;
            $data->orderType = $request->orderType;
            $data->conditionType = $request->conditionType;
            $data->loadingCharges = $request->loadingCharges;
            $data->oilContent = $request->oilContent;
            $data->freight = $request->freight;
            $data->labourCharges = $request->labourCharges;
            $data->mandiTax = $request->mandiTax;
            $data->location = $request->location;
            if(is_array($request->katta)){
                $data->katta = count($request->katta) > 0  ? implode(",",$request->katta) : null ;
                $data->bdBy = count($request->bdBy) > 0 ? implode(",",$request->bdBy) : null ;
                $data->bdType = count($request->bdType) > 0 ? implode(",",$request->bdType) : null ;
            }else{
                $data->katta = str_replace(["[","]"], "",$request->katta);
                $data->bdBy = str_replace(["[","]"], "",$request->bdBy);
                $data->bdType = str_replace(["[","]"], "",$request->bdType);
            }
            $data->product = $request->product;
            $data->updateId = $request->updateId;
            $data->customer = $request->user()->id;
            if($request->isMethod('put')){
                $data->timestamps = false;
            }else{
                $data->created_at = Now();
            }
            $data->status = 'pending';
            $data->save();
            
            $CurrentData = Http::withHeaders([
                'Accept' => 'application/json',
                'Authorization' => $request->header('Authorization'),
                ])->get(route('orderbyid', ['id' => $data->id]));
            
            $sendmsgtousers = User::whereRaw("find_in_set($data->product,product)")->whereIn('role',['admin','editor'])->pluck('phone')->toArray();
            $sendNumber = implode(', ',$sendmsgtousers);
            $this->SMS->sendSMS($sendNumber,json_decode((string) $CurrentData->getBody(),true),false,'newBid');
            
            $user = User::whereRaw("find_in_set($data->product,product)")->whereIn('role',['admin','editor'])->get();
            foreach($user as $u):
                $u->notify(new NewOrderNotification($data));
            endforeach;
            return response()->json(['action' => true, 'message' => "Bid Submitted Successfully."]);
        //}catch(Exception $error){
        //    return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
       // }
    }
    public function store(Request $request)
    {
        try{
            $date = new \DateTime();
            $date->modify('24 hours');
            $newDate = $date->format('Y-m-d');
            $data = Order::findOrFail($request->id);
            $data->fRate = $request->fRate;
            $data->fQty =  $request->fQty;
            $data->fBag =  $request->fBag;
            $data->fPaymentDate = $request->fPaymentDate =="" || $request->fPaymentDate ==null ? $newDate : $request->fPaymentDate;
            $data->fLoadingDate = $request->fLoadingDate =="" || $request->fLoadingDate ==null ? $newDate : $request->fLoadingDate;
            $data->manageBy =  $request->user()->id;
            $data->updated_at = Now();
            $data->save();

            $CurrentData = Http::withHeaders([
                'Accept' => 'application/json',
                'Authorization' => $request->header('Authorization'),
                ])->get(route('orderbyid', ['id' => $data->id]));

            $user = User::findOrFail($data->customer);
            $this->SMS->sendSMS($user->phone,json_decode((string) $CurrentData->getBody(),true),false,'finalRate');
            $user->notify(new FinalUpdateNotification($data));
            return response()->json(['action' => true, 'message' => "Bid Updated Successfully."]);
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
/* --------------- All Pending For Backend Orders ---------------- */
    public function showbackEndPendingPurchaseFormA($id)
    {
        //try{
            return PurchaseFormA::collection(Order::where('product','=',$id)->where('status','pending')->orderBy('created_at','desc')->get());
       // }catch(Exception $error){
            //return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        //}
    }
    public function showbackEndPendingPurchaseFormB($id)
    {
        try{
           return PurchaseFormB::collection(Order::where('product','=',$id)->where('status','pending')->orderBy('created_at','desc')->get());
        }catch(Exception $error){
           return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showbackEndPendingPurchaseFormC($id)
    {
        try{
           return PurchaseFormC::collection(Order::where('product','=',$id)->where('status','pending')->orderBy('created_at','desc')->get());
        }catch(Exception $error){
           return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showbackEndPendingSaleFormA($id)
    {
        try{
           return SaleFormA::collection(Order::where('product','=',$id)->where('status','pending')->orderBy('created_at','desc')->get());
        }catch(Exception $error){
           return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showbackEndPendingSaleFormB($id)
    {
        try{
           return SaleFormB::collection(Order::where('product','=',$id)->where('status','pending')->orderBy('created_at','desc')->get());
        }catch(Exception $error){
           return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }


/* --------------- All Approve For Backend Orders ---------------- */
    public function showbackEndApprovedPurchaseFormA($id)
    {
        try{
            return PurchaseFormA::collection(Order::where('product','=',$id)->where('status','approved')->orderBy('updated_at','desc')->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showbackEndApprovedPurchaseFormB($id)
    {
        try{
           return PurchaseFormB::collection(Order::where('product','=',$id)->where('status','approved')->orderBy('updated_at','desc')->get());
        }catch(Exception $error){
           return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showbackEndApprovedPurchaseFormC($id)
    {
        try{
           return PurchaseFormC::collection(Order::where('product','=',$id)->where('status','approved')->orderBy('updated_at','desc')->get());
        }catch(Exception $error){
           return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showbackEndApprovedSaleFormA($id)
    {
        try{
           return SaleFormA::collection(Order::where('product','=',$id)->where('status','approved')->orderBy('updated_at','desc')->get());
        }catch(Exception $error){
           return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showbackEndApprovedSaleFormB($id)
    {
        try{
           return SaleFormB::collection(Order::where('product','=',$id)->where('status','approved')->orderBy('updated_at','desc')->get());
        }catch(Exception $error){
           return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
/* --------------- All Not Approve For Backend Orders ---------------- */
    public function showbackEndNotApprovedPurchaseFormA($id)
    {
        try{
            return PurchaseFormA::collection(Order::where('product','=',$id)->where('status','notapproved')->orderBy('created_at','desc')->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showbackEndNotApprovedPurchaseFormB($id)
    {
        try{
            return PurchaseFormB::collection(Order::where('product','=',$id)->where('status','notapproved')->orderBy('created_at','desc')->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showbackEndNotApprovedPurchaseFormC($id)
    {
        try{
            return PurchaseFormC::collection(Order::where('product','=',$id)->where('status','notapproved')->orderBy('created_at','desc')->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showbackEndNotApprovedSaleFormA($id)
    {
        try{
            return SaleFormA::collection(Order::where('product','=',$id)->where('status','notapproved')->orderBy('created_at','desc')->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showbackEndNotApprovedSaleFormB($id)
    {
        try{
            return SaleFormB::collection(Order::where('product','=',$id)->where('status','notapproved')->orderBy('created_at','desc')->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }


    /* -------------------------- Customer Pending Show ------------------------------------ */
    public function showCustomerPendingPurchaseFormA(Request $request, $id)
    {
        try{
            return PurchaseFormA::collection(Order::where('product',$id)->where('customer', $request->user()->id)->where('status','pending')->orderBy('created_at','desc')->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showCustomerPendingPurchaseFormB(Request $request, $id)
    {
        try{
            return PurchaseFormB::collection(Order::where('product',$id)->where('customer', $request->user()->id)->where('status','pending')->orderBy('created_at','desc')->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showCustomerPendingPurchaseFormC(Request $request, $id)
    {
        try{
            return PurchaseFormC::collection(Order::where('product',$id)->where('customer', $request->user()->id)->where('status','pending')->orderBy('created_at','desc')->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showCustomerPendingSaleFormA(Request $request, $id)
    {
        try{
            return SaleFormA::collection(Order::where('product',$id)->where('customer', $request->user()->id)->where('status','pending')->orderBy('created_at','desc')->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showCustomerPendingSaleFormB(Request $request, $id)
    {
        try{
            return SaleFormB::collection(Order::where('product',$id)->where('customer', $request->user()->id)->where('status','pending')->orderBy('created_at','desc')->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }

    /* -------------------------- Customer Approved Show ------------------------------------ */
    public function showCustomerApprovedPurchaseFormA(Request $request, $id)
    {
        try{
            return PurchaseFormA::collection(Order::where('product',$id)->where('customer', $request->user()->id)->where('status','approved')->orderBy('updated_at','desc')->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showCustomerApprovedPurchaseFormB(Request $request, $id)
    {
        try{
            return PurchaseFormB::collection(Order::where('product',$id)->where('customer', $request->user()->id)->where('status','approved')->orderBy('updated_at','desc')->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showCustomerApprovedPurchaseFormC(Request $request, $id)
    {
        try{
            return PurchaseFormC::collection(Order::where('product',$id)->where('customer', $request->user()->id)->where('status','approved')->orderBy('updated_at','desc')->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showCustomerApprovedSaleFormA(Request $request, $id)
    {
        try{
            return SaleFormA::collection(Order::where('product',$id)->where('customer', $request->user()->id)->where('status','approved')->orderBy('updated_at','desc')->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showCustomerApprovedSaleFormB(Request $request, $id)
    {
        try{
            return SaleFormB::collection(Order::where('product',$id)->where('customer', $request->user()->id)->where('status','approved')->orderBy('updated_at','desc')->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }

     /* -------------------------- Customer Approved Show ------------------------------------ */
     public function showCustomerNotApprovedPurchaseFormA(Request $request, $id)
     {
         try{
             return PurchaseFormA::collection(Order::where('product',$id)->where('customer', $request->user()->id)->where('status','notapproved')->orderBy('created_at','desc')->get());
         }catch(Exception $error){
             return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
         }
     }
     public function showCustomerNotApprovedPurchaseFormB(Request $request, $id)
     {
         try{
             return PurchaseFormB::collection(Order::where('product',$id)->where('customer', $request->user()->id)->where('status','notapproved')->orderBy('created_at','desc')->get());
         }catch(Exception $error){
             return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
         }
     }
     public function showCustomerNotApprovedPurchaseFormC(Request $request, $id)
     {
         try{
             return PurchaseFormC::collection(Order::where('product',$id)->where('customer', $request->user()->id)->where('status','notapproved')->orderBy('created_at','desc')->get());
         }catch(Exception $error){
             return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
         }
     }
     public function showCustomerNotApprovedSaleFormA(Request $request, $id)
     {
         try{
             return SaleFormA::collection(Order::where('product',$id)->where('customer', $request->user()->id)->where('status','notapproved')->orderBy('created_at','desc')->get());
         }catch(Exception $error){
             return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
         }
     }
     public function showCustomerNotApprovedSaleFormB(Request $request, $id)
     {
         try{
             return SaleFormB::collection(Order::where('product',$id)->where('customer', $request->user()->id)->where('status','notapproved')->orderBy('created_at','desc')->get());
         }catch(Exception $error){
             return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
         }
     }

    /* ------------------------------------ Show Backend ---------------------------------------------*/

    public function showBackendPurchaseFormA($id)
    {
        try{
            return PurchaseFormA::collection(Order::where('product','=',$id)->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showBackendPurchaseFormB($id)
    {
        try{
            return PurchaseFormB::collection(Order::where('product','=',$id)->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showBackendPurchaseFormC($id)
    {
        try{
            return PurchaseFormC::collection(Order::where('product','=',$id)->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showBackendSaleFormA($id)
    {
        try{
            return SaleFormA::collection(Order::where('product','=',$id)->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showBackendSaleFormB($id)
    {
        try{
            return SaleFormB::collection(Order::where('product','=',$id)->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }

    /*-------------------------------- Single order Show backend --------------------------------------*/
     /* ------------------------------------ Show Backend ---------------------------------------------*/

    public function showByIdPurchaseFormA($id)
    {
        try{
           return  New PurchaseFormA(Order::findOrFail($id));
        }catch(Exception $error){
           return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showByIdPurchaseFormB($id)
    {
        try{
           return  New PurchaseFormB(Order::findOrFail($id));
        }catch(Exception $error){
           return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showByIdPurchaseFormC($id)
    {
        try{
           return  New PurchaseFormC(Order::findOrFail($id));
        }catch(Exception $error){
           return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showByIdSaleFormA($id)
    {
        try{
           return  New SaleFormA(Order::findOrFail($id));
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function showByIdSaleFormB($id)
    {
        try{
           return  New SaleFormB(Order::findOrFail($id));
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function multiple($id){
       try{
            $ids = explode(",",$id);
            return PurchaseFormA::collection(Order::whereIn('id',$ids)->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
        
        
    }
    // Approve Bid
    public function sendByAdmin(Request $request, $id){
        //try{

            $CurrentData = Http::withHeaders([
                'Accept' => 'application/json',
                'Authorization' => $request->header('Authorization'),
                ])->post(route('multipleorders', ['id' => $id]));
            
            $emailSender = User::whereIn('role',['admin'])->pluck('email')->toArray();
            $email = implode(', ',$emailSender);
            $this->MAIL->sendMail(json_decode((string) $CurrentData->getBody(),true), $email.', grgoilbargains@gmail.com','admin');
            return response()->json(['action' => true, 'message' => "Eamil has been Sent Successfully."]);
        //}catch(Exception $error){
         //   return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
       // }
    }

// Approve Bid
    public function approveBid(Request $request){
        //try{
            $data = Order::findOrFail($request->id);
            if($data->status == 'notapproved'){
                return response()->json(['action' => false, 'message' => "Bid has been expired. Please refresh the page and bid again."]);
            }else{
            $product = Product::findOrFail($data->product);
            $lastorder = Order::where('product',$data->product)->where('status','approved')->orderBy('updated_at','DESC')->first();
            //return response()->json($lastorder);
            $lastBargain = $lastorder == null ? '' :  explode('|',$lastorder->bargainNo);
            $lastPrefix = $lastorder == null ? '' : $lastBargain[0];
            $lastYear = $lastorder == null ? '' : $lastBargain[1];
            $lastValue = $lastorder == null ? '' : intval($lastBargain[2]);
            $currentYear = date('y');
            //return response()->json(['lastBargain' => $lastBargain, 'lastPrefix' => $lastPrefix, 'lastYear' => $lastYear, 'lastValue' => $lastValue]);
            //die();
            if($lastorder == null){
                $bargainNo = $product->preFix.'|'.$currentYear.'|1';
            }else{
                if($lastYear == $currentYear && $lastPrefix == $product->preFix){
                    $incVal = $lastValue + 1;
                    $bargainNo = $product->preFix.'|'.$currentYear.'|'.$incVal;
                }else{
                    $bargainNo = $product->preFix.'|'.$currentYear.'|1';
                }
            }
            $data->bargainNo = $bargainNo;
            $data->open = 'notopen';
            $data->status =  'approved';
            $data->approvedAt = Now();
            $data->save();

            $CurrentNewData = Http::withHeaders([
                'Accept' => 'application/json',
                'Authorization' => $request->header('Authorization'),
                ])->post(route('multipleorders', ['id' => $data->id]));
            
            //$emailSender = User::whereIn('role',['admin'])->pluck('email')->toArray();
            //$email = implode(', ',$emailSender);
            $this->MAIL->sendMail(json_decode((string) $CurrentNewData->getBody(),true), 'grgoilbargains@gmail.com, lokeshgoyal09@gmail.com','admin');
           
            $CurrentData = Http::withHeaders([
                'Accept' => 'application/json',
                'Authorization' => $request->header('Authorization'),
                ])->get(route('orderbyid', ['id' => $data->id]));
           
           
            $user = User::findOrFail($data->customer);
            $sendmsgtousers = User::whereRaw("find_in_set($data->product,product)")->whereIn('role',['admin','editor'])->pluck('phone')->toArray();
            $sendNumber = implode(', ',$sendmsgtousers);
            $this->SMS->sendSMS($user->phone.', '.$sendNumber,json_decode((string) $CurrentData->getBody(),true),false,'approved');
            $user = User::whereRaw("find_in_set($data->product,product)")->whereIn('role',['admin','editor'])->get();
            foreach($user as $u):
                $u->notify(new ApprovedNotification($data));
            endforeach;

            return response()->json(['action' => true, 'message' => "Bid Approved Successfully."]);
            }
        //}catch(Exception $error){
         //   return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
       // }
    }

// Custmor Update
    public function updatePurchaseFormA(Request $request){
        try{
            $data = Order::findOrFail($request->id);
            $data->id = $request->id;
            $data->oRate = $request->oRate;
            $data->oilContent = $request->oilContent;
            $data->oQty = $request->oQty;
            $data->oBag = $request->oBag;
            $data->loadingCharges = $request->loadingCharges;
            $data->freight = $request->freight;
            $data->labourCharges = $request->labourCharges;
            $data->mandiTax = $request->mandiTax;
            $data->location = $request->location;
            if(isset($request->katta) && isset($request->bdBy) && isset($request->bdType)){
            $data->katta = $request->katta != '' ? implode(',',$request->katta) : null ;
            $data->bdBy = $request->bdBy != '' ? implode(',',$request->bdBy) : null ;
            $data->bdType = $request->bdType  != '' ? implode(',',$request->bdType) : null ;
            }else{
                //
            }
            $data->save();

            $CurrentData = Http::withHeaders([
                'Accept' => 'application/json',
                'Authorization' => $request->header('Authorization'),
                ])->get(route('orderbyid', ['id' => $data->id]));

            $sendmsgtousers = User::whereRaw("find_in_set($data->product,product)")->whereIn('role',['admin','editor'])->pluck('phone')->toArray();
            $sendNumber = implode(', ',$sendmsgtousers);
            $this->SMS->sendSMS($sendNumber,json_decode((string) $CurrentData->getBody(),true),false,'updateBid');
            return response()->json(['action' => true, 'message' => "Bid Updated Successfully."]);
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }

    }

    public function updatePurchaseFormB(Request $request){
        try{
            $data = Order::findOrFail($request->id);
            $data->id = $request->id;
            $data->oRate = $request->oRate;
            $data->oQty = $request->oQty;
            $data->oBag = $request->oBag;
            $data->location = $request->location;
            $data->save();


            $CurrentData = Http::withHeaders([
                'Accept' => 'application/json',
                'Authorization' => $request->header('Authorization'),
                ])->get(route('orderbyid', ['id' => $data->id]));

            $sendmsgtousers = User::whereRaw("find_in_set($data->product,product)")->whereIn('role',['admin','editor'])->pluck('phone')->toArray();
            $sendNumber = implode(', ',$sendmsgtousers);
            $this->SMS->sendSMS($sendNumber,json_decode((string) $CurrentData->getBody(),true),false,'updateBid');
            return response()->json(['action' => true, 'message' => "Bid Updated Successfully."]);
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }

    public function updatePurchaseFormC(Request $request){
        try{
            $data = Order::findOrFail($request->id);
            $data->id = $request->id;
            $data->oRate = $request->oRate;
            $data->oQty = $request->oQty;
            $data->freight = $request->freight;
            $data->location = $request->location;
            $data->save();

            $CurrentData = Http::withHeaders([
                'Accept' => 'application/json',
                'Authorization' => $request->header('Authorization'),
                ])->get(route('orderbyid', ['id' => $data->id]));


            $sendmsgtousers = User::whereRaw("find_in_set($data->product,product)")->whereIn('role',['admin','editor'])->pluck('phone')->toArray();
            $sendNumber = implode(', ',$sendmsgtousers);
            $this->SMS->sendSMS($sendNumber,json_decode((string) $CurrentData->getBody(),true),false,'updateBid');
            return response()->json(['action' => true, 'message' => "Bid Updated Successfully."]);
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }

    public function updateSaleFormA(Request $request){
        try{
            $data = Order::findOrFail($request->id);
            $data->id = $request->id;
            $data->oRate = $request->oRate;
            $data->oQty = $request->oQty;
            $data->oPaymentDate = $request->oPaymentDate;
            $data->oLoadingDate = $request->oLoadingDate;
            $data->save();

            $CurrentData = Http::withHeaders([
                'Accept' => 'application/json',
                'Authorization' => $request->header('Authorization'),
                ])->get(route('orderbyid', ['id' => $data->id]));


            $sendmsgtousers = User::whereRaw("find_in_set($data->product,product)")->whereIn('role',['admin','editor'])->pluck('phone')->toArray();
            $sendNumber = implode(', ',$sendmsgtousers);
            $this->SMS->sendSMS($sendNumber,json_decode((string) $CurrentData->getBody(),true),false,'updateBid');
            return response()->json(['action' => true, 'message' => "Bid Updated Successfully."]);
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }

    public function updateSaleFormB(Request $request){
        try{
            $data = Order::findOrFail($request->id);
            $data->id = $request->id;
            $data->oRate = $request->oRate;
            $data->oQty = $request->oQty;
            $data->oLoadingDate = $request->oLoadingDate;
            $data->save();

            $CurrentData = Http::withHeaders([
                'Accept' => 'application/json',
                'Authorization' => $request->header('Authorization'),
                ])->get(route('orderbyid', ['id' => $data->id]));

            $sendmsgtousers = User::whereRaw("find_in_set($data->product,product)")->whereIn('role',['admin','editor'])->pluck('phone')->toArray();
            $sendNumber = implode(', ',$sendmsgtousers);
            $this->SMS->sendSMS($sendNumber,json_decode((string) $CurrentData->getBody(),true),false,'updateBid');
            return response()->json(['action' => true, 'message' => "Bid Updated Successfully."]);
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }

    public function destroy($id)
    {
        try{
            $del = New Order();
            $del->whereIn('id',explode(",",$id))->delete();
            return response()->json(['action' => true, 'message' => "Selectd orders has been deleted"]);
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
}
