<?php

namespace App\Http\Controllers;

use App\Models\OrderParty;
use App\Models\Order;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Resources\OrderPartyResources;
use Exception;
class OrderPartyController extends Controller
{
    private $SMS;
    public function __construct()
    {
        $this->SMS = new SmsController();
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($id)
    {
        try{
            return OrderPartyResources::collection(OrderParty::where('order', $id)->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function store(Request $request)
    {
        //t//ry{
            $orderData = Order::findOrFail($request->order);
            $totalqty = OrderParty::where('order',$request->order)->sum('qty');
            $pending = $orderData->fQty - $totalqty;
            if($request->qty <= 0 || $request->qty == '' || !is_numeric($request->qty)){
                return response()->json(['action' => false, 'message' => "Please enter valid Value"]);
            }
            if($pending < $request->qty){
                return response()->json(['action' => false, 'message' => "Enterd qty is more than final qty"]);
            }else{
                $lastorder = OrderParty::where('order',$request->order)->orderBy('created_at','desc')->first();
                if($lastorder == null){
                    $orderId = $orderData->bargainNo.'-1';
                }else{
                    $data = explode('-',$lastorder->orderId);
                    $newData = intval($data[1]) + 1;
                    $orderId = $orderData->bargainNo.'-'.$newData;
                }
                $data = $request->isMethod('put') ? OrderParty::findOrFail($request->id) : new OrderParty();
                $data->id = $request->input('id');
                $data->qty = $request->qty;
                $data->order = $request->order;
                $data->party = $request->party;
                $data->orderId = $orderId;
                $data->save();


                $CurrentData = Http::withHeaders([
                    'Accept' => 'application/json',
                    'Authorization' => $request->header('Authorization'),
                    ])->get(route('orderbyid', ['id' => $request->order]));

                $CurrentData2 = Http::withHeaders([
                        'Accept' => 'application/json',
                        'Authorization' => $request->header('Authorization'),
                        ])->get(route('partybyidinorder', ['id' => $data->id]));
                
                $user = User::findOrFail($request->user()->id);
                $sendmsgtousers = User::whereIn('role',['admin','editor'])->pluck('phone')->toArray();
                $sendNumber = implode(', ',$sendmsgtousers);
                $this->SMS->sendSMS($user->phone.', '.$sendNumber,json_decode((string) $CurrentData->getBody(),true), json_decode((string) $CurrentData2->getBody(),true),'partyAdd');
                
                
                $message = $request->isMethod('put') ? response()->json(['action' => true, 'message' => "Party has been Added"]) :
                response()->json(['action' => true, 'message' => "Party has been Added"]);
                return $message;
            }
        //}catch(Exception $error){
       //     return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
       // }
    }
    public function bymultiple($id)
    {
        try{
            $ides = explode(',',$id);
            return OrderPartyResources::collection(OrderParty::whereIn('order', $ides)->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
     public function show($id)
    {
        try{
            return  New OrderPartyResources(OrderParty::findOrFail($id));
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function destroy(OrderParty $orderParty)
    {

    }
}
