<?php

namespace App\Http\Controllers;
use Exception;
use App\Models\PartyAddress;
use Illuminate\Http\Request;

class PartyAddressController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        return PartyAddress::where('customer',$request->user()->id)->latest()->get();
    }

    public function store(Request $request)
    {
        try{
            $data = $request->isMethod('put') ? PartyAddress::findOrFail($request->id) : new PartyAddress();
            $data->id = $request->input('id');
            $data->personName = $request->input('personName');
            $data->companyName = $request->input('companyName');
            $data->phone = $request->input('phone');
            $data->email = $request->input('email');
            $data->gst = $request->input('gst');
            $data->status = $request->input('status');
            $data->state = $request->input('state');
            $data->city = $request->input('city');
            $data->address = $request->input('address');
            $data->pincode = $request->input('pincode');
            $data->save();
            $message = $request->isMethod('put') ? response()->json(['action' => true, 'message' => "Party has been updated"]) :
            response()->json(['action' => true, 'message' => "Party has been created"]);
            return $message;
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Party  $party
     * @return \Illuminate\Http\Response
     */
    public function show(PartyAddress $PartyAddress)
    {
        return $PartyAddress;
    }
    public function destroy(PartyAddress $party)
    {
        //
    }
}
