<?php

namespace App\Http\Controllers;

use App\Http\Resources\PartyResources;
use App\Models\Party;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PartyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return PartyResources::collection(Party::all());
    }

    public function store(Request $request)
    {
        try{
            $data = $request->isMethod('put') ? Party::findOrFail($request->id) : new Party();
            $data->id = $request->input('id');
            $data->personName = $request->input('personName');
            $data->companyName = $request->input('companyName');
            $data->bussinessType = $request->input('bussinessType');
            $data->phone = $request->input('phone');
            $data->email = $request->input('email');
            $data->gst = $request->input('gst');
            $data->state = $request->input('state');
            $data->city = $request->input('city');
            $data->address = $request->input('address');
            $data->pincode = $request->input('pincode');
            $data->bankName = $request->input('bankName');
            $data->bankAc = $request->input('bankAc');
            $data->ifsc = $request->input('ifsc');
            $data->save();
            $message = $request->isMethod('put') ? response()->json(['action' => true, 'message' => "Party has been updated"]) :
            response()->json(['action' => true, 'message' => "Party has been created"]);
            return $message;
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Party  $party
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try{
            return new PartyResources(Party::findOrFail($id));
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function destroy($id)
    {
        try{
            $del = New Party();
            $del->whereIn('id',explode(",",$id))->delete();
            return response()->json(['action' => true, 'message' => "Selected Party has been deleted"]);
         }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
         }
    }
}
