<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\Order;
use App\Models\OrderParty;
use Illuminate\Http\Request;
use App\Http\Resources\ProductData;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;

class ProductController extends Controller
{
    public function index()
    {
        try{
            return ProductData::collection(Product::all());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }

    public function store(Request $request)
    {
        try{
            $data = $request->isMethod('put') ? Product::findOrFail($request->id) : new Product();
            $this->validate($request,[
                'name'=>'required',
             ]);
            $data->id = $request->input('id');
            $data->name = $request->input('name');
            $data->nature = $request->input('nature');
            $data->preFix = $request->input('preFix');
            $data->aConditions = $request->input('aConditions');
            $data->pF = $request->input('pF');
            $data->tC = $request->input('tC');
            $data->productOrder = $request->input('productOrder');
            $data->status = $request->input('status');
            $data->save();
            $message = $request->isMethod('put') ? response()->json(['action' => true, 'message' => "Product has been updated"]) :
            response()->json(['action' => true, 'message' => "Product has been created"]);
            return $message;
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }

    public function showbyUser(Request $request)
    {
        try{
            $userproduct = explode(',', $request->user()->product);
            return ProductData::collection(Product::whereIn('id',$userproduct)->orderBy('productOrder','asc')->get());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    public function show($id)
    {
        try{
            return New ProductData(Product::findOrFail($id));
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }

    public function destroy($id)
    {
        try{
           $order = New Order();
           $party = New OrderParty();
           $deldata = $order->whereIn('product',explode(",",$id))->pluck('id')->toArray();
           $party->whereIn('order',$deldata)->delete();
           $Delorder = New Order();
           $Delorder->whereIn('product',explode(",",$id))->delete();
           $del = New Product();
           $del->whereIn('id',explode(",",$id))->delete();
           return response()->json(['action' => true, 'message' => "Selected Products and their data has been deleted"]);
        }catch(Exception $error){
           return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
}
