<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class SmsController extends Controller
{
    private $SMS_SENDER = "GRGOIL";
    private $RESPONSE_TYPE = 'json';
    private $SMS_USERNAME = "u4014";
    private $SMS_PASSWORD = "Q9Uc5N";
    private $SMS_API = "http://103.238.223.66/api/send_transactional_sms.php?";


    
    public function sendSMS($phone_number, $message, $msgS = false,  $type)
    {
        //return $this->Message($message,$type);
        $isError = 0;
        $errorMessage = true;
        //Preparing post parameters
        $postData = array(
            'username' => $this->SMS_USERNAME,
            'msg_token' => $this->SMS_PASSWORD,
            'message' => $this->Message($message, $msgS, $type),
            'sender_id' => $this->SMS_SENDER,
            'mobile' => $phone_number,
            'response' => $this->RESPONSE_TYPE
        );
        $url = "http://103.238.223.66/api/send_transactional_sms.php";
        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $postData
        ));
        //Ignore SSL certificate verification
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        //get response
        $output = curl_exec($ch);
        //Print error if any
        if (curl_errno($ch)) {
            $isError = true;
            $errorMessage = curl_error($ch);
        }
        curl_close($ch);
        if($isError){
            return array('error' => 1 , 'message' => $errorMessage);
        }else{
            return array('error' => 0 );
        }
    }
    public function Message($message, $msgS, $type){
        if($type == 'approved'){
            return $this->approved($message);
        }elseif($type == 'finalRate'){
            return  $this->finalRate($message);
        }elseif($type == 'newBid'){
            return  $this->newBid($message);
        }elseif($type == 'updateBid'){
            return  $this->updateBid($message);
        }elseif($type == 'partyAdd'){
            return  $this->partyAdd($message,$msgS);
        }else{
            return $this->update($message);
        }
    }
    public function partyAdd($message,$msgS){
        $data = $message['data'];
        $dataS = $msgS['data'];
        return 'Party Added, '.$dataS['partyName'].', Location:'.$dataS['partyLocation'].', Bargin No:'.$dataS['orderId'].', '.$data['productName'].', '.$data['msgCondition'].', Rate:'.$data['fRate'].'/Qtl., Qty:'.$dataS['qty'].'/Tons. By '.$data['customer'].'.';
        
    }
    public function updateBid($message){
        $data = $message['data'];
            return 'Bid Updated, Order No:'.$data['id'].', '.$data['productName'].', '.$data['msgCondition'].', Offer Rate:'.$data['oRate'].'/Qtl., Offer Qty:'.$data['oQty'].'/Tons. By '.$data['customer'];
        
    }
    public function newBid($message){
        $data = $message['data'];
            return 'New Bid on '.$data['productName'].', '.$data['msgCondition'].', Offer Rate:'.$data['oRate'].'/Qtl., Offer Qty:'.$data['oQty'].'/Tons. By '.$data['customer'];
        
    }
    
    public function approved($message){
        $data = $message['data'];
            return 'Bargain Confirmation Shree GRG-SGNR, '.$data['productName'].', '.$data['msgCondition'].', Final Rate:'.$data['fRate'].'/Qtl., Final Qty:'.$data['fQty'].'/Tons. By '.$data['customer'].'. Thanks for your approval';
    }
    public function finalRate($message){
        $data = $message['data'];
            return 'Shree GRG-SGNR, '.$data['productName'].', '.$data['msgCondition'].', Final Rate:'.$data['fRate'].'/Qtl., Final Qty:'.$data['fQty'].'/Tons. has been updated. Approve NOW';
        
        
    }
    public function update($message){
        $data = $message['data'];
        if($data['productForm'] == 'PurchaseFormA'){
            return 'Shree GRG-SGNR, '.$data['productName'].', Condition 42% Rate:'.$data['conditionRate'].'/Qtl, EX-Non Condition Rate:'.$data['nonConditionRate'].'/Qtl';
        }
         if($data['productForm'] == 'PurchaseFormB'){
            return 'Shree GRG-SGNR, '.$data['productName'].', Solvent Condition Rate:'.$data['conditionRate'].'/Qtl, Non-Condition Rate:'.$data['nonConditionRate'].'/Qtl';
        }
         if($data['productForm'] == 'PurchaseFormC'){
            return 'Shree GRG-SGNR, '.$data['productName'].',  PB/HR, EX-LOOSE Rate:'.$data['looseRatePbHr'].'/Qtl, Sumerpur, EX-LOOSE Rate:'.$data['looseRateSumerpur'].'/Qtl';
        }
         if($data['productForm'] == 'SaleFormA'){
            return 'Shree GRG-SGNR, '.$data['productName'].', LOOSE-READY Rate:'.$data['readyRate'].'/Qtl, Upto '.$data['readyLIn'].',  LOOSE-FORWARD Rate:'.$data['forwardRate'].'/Qtl, Upto '.$data['forwardLIn']; 
        }
        if($data['productForm'] == 'SaleFormB'){
            return 'Shree GRG-SGNR, '.$data['productName'].', EX-READY Rate:'.$data['readyRate'].'/Qtl, Lifting within '.$data['readyLIn'].' Days,  EX-FORWARD Rate:'.$data['forwardRate'].'/Qtl, Lifting within '.$data['forwardLIn'].' Days'; 
        }
    }
}
