<?php

namespace App\Http\Controllers;

use App\Models\state_cities;
use App\Http\Resources\State_city as StateCityResource;
use Illuminate\Http\Request;

class StateCitiesController extends Controller
{
   /* Fetch All State */
   public function state()
   {
       try{
           return StateCityResource::collection(state_cities::select(\DB::raw('DISTINCT `state`'))->get());
       }catch(Exception $error){
           return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
       }
   }

   /* Fetch All cities */
   public function city($id)
   {
       try{
           return StateCityResource::collection(state_cities::where('state', $id)->get());
       }catch(Exception $error){
           return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
       }
   }

   /* Update And Create New Records */
   
}
