<?php

namespace App\Http\Controllers;

use App\Models\Unit;
use Illuminate\Http\Request;
use App\Http\Resources\UnitData;

class UnitController extends Controller
{
    public function index()
    {
        try{
            return UnitData::collection(Unit::all());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    
    public function store(Request $request)
    {
        try{
            $data = $request->isMethod('put') ? Unit::findOrFail($request->id) : new Unit();
            $data->id = $request->input('id');
            $data->name = $request->input('name');
            $data->state = $request->input('state');
            $data->city = $request->input('city');
            $data->address = $request->input('address');
            $data->phone = $request->input('phone');
            $data->email = $request->input('email');
            $data->cPerson = $request->input('cPerson');
            $data->status = $request->input('status');
            $data->save();
            $message = $request->isMethod('put') ? response()->json(['action' => true, 'message' => "Unit has been updated"]) :
            response()->json(['action' => true, 'message' => "Unit has been created"]);
            return $message;
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }   
    }
    
    public function show($id)
    {
        try{
            return New UnitData(Unit::findOrFail($id));
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }   
    }
    
    public function destroy($id)
    {
        try{
            $del = New Unit();
            $del->whereIn('id',explode(",",$id))->delete();
            return response()->json(['action' => true, 'message' => "Selected Unit has been deleted"]);
         }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
         }
    }
}
