<?php

namespace App\Http\Controllers;
use App\Models\User;
use App\Models\Order;
use App\Models\OrderParty;
use Illuminate\Http\Request;
// Resources for Login User
use App\Http\Resources\UserData;

// Resources For Backend Manager
use App\Http\Resources\UserInfo;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class UserController extends Controller
{
    // Fetch Loged in User Info
    public function UserInfo(Request $request){
        return response()->json(New UserInfo($request->user()));
    }




    public function login(Request $request)
    {
       // try {
            $request->validate([
                'username' => 'required',
                'password' => 'required',
            ]);
            $usernameOrEmail = $request->username;
            $user = User::where(function ($query) use ($usernameOrEmail) {
                $query->where('username', $usernameOrEmail)
                      ->orWhere('email', $usernameOrEmail);
            })
            ->where('status', 1)
            ->first();

            if (!$user || !Hash::check($request->password, $user->password)) {
                return response()->json(['validation' => 'Wrong Credentials!'], 422);
            }

            $token = $user->createToken('codeharry')->plainTextToken;
            return response()->json(['message'=> 'Login Successfully', 'action' => true, 'token' => $token, 'loginManage' => $user],200);
            return response()->json(['token' => $token], 200);
       // } catch (\Exception $e) {
        //    return response()->json(['error' => $e->getMessage()], $e->getCode());
       // }
    }

















    /*public function login(Request $request){
        $http = new Client;
        try {
            $response = $http->post('http://esource.shreegrgoilmill.com/backend/public/oauth/token', [
                'form_params' => [
                    'grant_type' => 'password',
                    'client_id' => '2',
                    'client_secret' => '1TBJsw22POLgGX9XqjenW6mqSmKl8JKCX9v0cusN',
                    'username' => $request->username,
                    'password' => $request->password,
                    'scope' => ''
                ]
            ]);
            $makeToken = json_decode((string) $response->getBody(), true);
            $token = $makeToken['access_token'];
            $userdetail = $http->get(route('userinfo'), [
                'headers' => [
                    'Accept' => 'application/json',
                    'Authorization' => 'Bearer '.$token,
                ],
            ]);
            return response()->json(['message'=> 'Login Successfully', 'action' => true, 'data' => json_decode((string) $response->getBody(), true), 'loginManage' => json_decode((string) $userdetail->getBody(), true)],200);
        } catch (\GuzzleHttp\Exception\BadResponseException $e) {
            if ($e->getCode() === 400) {
                return response()->json(['message' => 'Invalid Request. Your credentials are incorrect. Please try again', 'action' => false, 'error' => $e->getCode()], 400);
            } else if ($e->getCode() === 401) {
                return response::json(['message' => 'Your credentials are incorrect. Please try again', 'action' => false, 'error' => $e->getCode()], 401);
            } else if($e->getCode() === 404) {
                return response()->json(['message' => 'Your credentials are incorrect', 'action' => false, 'error' => $e->getCode()], 404);
            }
            return response()->json(['message' => 'Something went wrong on the server.', 'action' => false, 'error' => $e->getCode()], 500);
        }
    }*/
    
    // update Status
    public function statusUpdate(Request $request){
        try{
            $data = User::findOrFail($request->id);
            $data->id = $request->input('id');
            $data->status = $request->input('status');
            $data->save();
            
            $message = $request->status == 0 ? 'User has been Deactivated' : 'User has been Activated';
           
            return response()->json(['message'=> $message, 'action' => true]);
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }

    // Logout
    public function Logout(Request $request){
        try{
           //$request->user()->token()->revoke();
           $request->user()->token()->delete();
            return response()->json(['message'=> 'Logged out successfully', 'action' => true]);
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }

    // Fetch All Users
    public function index()
    {
        try{
            return UserData::collection(User::all());
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }

    // Create And Update Users
    public function store(Request $request)
    {
        try{
            if($request->isMethod('put')){
                $validatedData = $request->validate([
                    'name' => 'required',
                    'email' => 'required|email',
                    //'phone' => 'required|regex:/[0-9]{9}/|max:10',
                    'username' => 'required',
                    'role' => 'required',
                    'product' => 'required',
                ]);
            }else{
                 $validatedData = $request->validate([
                    'name' => 'required',
                    'email' => 'unique:users|required|email',
                    'phone' => 'required|unique:users|regex:/[0-9]{9}/|max:10',
                    'username' => 'required|unique:users',
                    'password' => 'required|min:4',
                    'role' => 'required',
                    'product' => 'required',
                ]);
            }
            $data = $request->isMethod('put') ? User::findOrFail($request->id) : new User();
            $data->id = $request->input('id');
            $data->name = $request->input('name');
            $data->email = $request->input('email');
            $data->phone = $request->input('phone');
            $data->company = $request->input('company');
            $data->username = $request->input('username');
            $data->role = $request->input('role');
            //$data->unit = implode(',',$request->input('unit'));
            $data->product = implode(',',$request->input('product'));
            $data->unit = $request->input('unit');
            //$data->product = $request->input('product');
            $data->status = $request->input('status');
            if($request->isMethod('put')){
                if(empty($request->input('password'))){
                    //
                }else{
                    $data->password = bcrypt($request->input('password'));
                }
            }else{
                $data->password = bcrypt($request->input('password'));
            }
            $data->save();
            $message = $request->isMethod('put') ? response()->json(['action' => true, 'message' => "User has been updated"]) :
            response()->json(['action' => true, 'message' => "User has been created"]);
            return $message;
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
    
    public function setting(Request $request)
    {
        try{
            $data = User::findOrFail($request->user()->id);
            $data->id = $request->user()->id;
            $data->name = $request->input('name');
            $data->company = $request->input('company');
            $data->email = $request->input('email');
            $data->phone = $request->input('phone');
            if(empty($request->input('password'))){
                //
            }else{
                $data->password = bcrypt($request->input('password'));
            }
            $data->save();
            return response()->json(['action' => true, 'message' => "Setting has been updated"]);
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }

    // Fetch User By Id
    public function show($id)
    {
        try{
            return New UserData(User::findOrFail($id));
        }catch(Exception $error){
            return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }

    // Delete Users
    public function destroy($id)
    {
        try{
           $order = New Order();
           $party = New OrderParty();
           $deldata = $order->whereIn('customer',explode(",",$id))->pluck('id')->toArray();
           $party->whereIn('order',$deldata)->delete();
           $Delorder = New Order();
           $Delorder->whereIn('customer',explode(",",$id))->delete();
           $del = New User();
           $del->whereIn('id',explode(",",$id))->delete();
           return response()->json(['action' => true, 'message' => "Selected users and their data has been deleted"]);
        }catch(Exception $error){
           return response()->json(['action' => false, 'message' => "Somting not good!", 'error' => $error]);
        }
    }
}
