<?php

namespace App\Http\Resources;
use App\Models\Location;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\User;
use App\Models\Order;
use Illuminate\Support\Facades\Auth;
class CustmorDahsboard extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function validateDate($date, $format = 'Y-m-d'){
        $d = \DateTime::createFromFormat($format, $date);
        return $d && $d->format($format) == $date;
    }
    public function toArray($request)
    {
        if($this->locationId !=''){
            $data = Location::LocdataById($this->locationId);
                //$forForwardRate = '';
                //$forReadyRate = '';
            if($this->productData->pF == 'SaleFormB'){
                $forReadyRate = $this->readyRate == 0 ||$this->readyRate == null ? 0 : $this->readyRate +  $data->interest + $data->loadingCarges + $data->freight + $data->other + $data->gst;
                $forForwardRate = $this->forwardRate == 0 || $this->forwardRate == null ? 0 : $this->forwardRate +  $data->interest + $data->loadingCarges + $data->freight + $data->other + $data->gst;
            }
            }else{
                $data = Location::Locdata();
                    //$forForwardRate = '';
                    //$forReadyRate = '';
                if($this->productData->pF == 'SaleFormB'){
                    $forReadyRate = $this->readyRate == 0 ||$this->readyRate == null ? 0 : $this->readyRate +  $data->interest + $data->loadingCarges + $data->freight + $data->other + $data->gst;
                    $forForwardRate = $this->forwardRate == 0 || $this->forwardRate == null ? 0 : $this->forwardRate +  $data->interest + $data->loadingCarges + $data->freight + $data->other + $data->gst;
                }
            }
        // Musted Doc Button Settings
        if($this->MusterdDocA['status'] == 'pending' && $this->MusterdDocA['fRate'] == null){
            $MDA = 'update';
        }else if($this->MusterdDocA['status'] == 'pending' && $this->MusterdDocA['fRate'] != null){
            $MDA = 'approved';
        }else{
            $MDA ='bidNow';
        }//
        if($this->MusterdDocB['status'] == 'pending' && $this->MusterdDocB['fRate'] == null){
            $MDB = 'update';
        }else if($this->MusterdDocB['status'] == 'pending' && $this->MusterdDocB['fRate'] != null){
            $MDB = 'approved';
        }else{
            $MDB ='bidNow';
        }//
        if($this->MusterdDocC['status'] == 'pending' && $this->MusterdDocC['fRate'] == null){
            $MDC = 'update';
        }else if($this->MusterdDocC['status'] == 'pending' && $this->MusterdDocC['fRate'] != null){
            $MDC = 'approved';
        }else{
            $MDC ='bidNow';
        }//
        if($this->MusterdDocD['status'] == 'pending' && $this->MusterdDocD['fRate'] == null){
            $MDD = 'update';
        }else if($this->MusterdDocD['status'] == 'pending' && $this->MusterdDocD['fRate'] != null){
            $MDD = 'approved';
        }else{
            $MDD ='bidNow';
        }
        //------------------------------------------------------------------------------------------------
        // Musted Refined Button Settings
        if($this->productData->pF == 'SaleFormA'){
            $BTREADY = order::formSaleFormA($this->id,$this->product,'ready');
            if($BTREADY != null){
                if($BTREADY->status == 'pending' && $BTREADY->fRate == null){
                    $button1 = 'update';
                }else if($BTREADY->status == 'pending' && $BTREADY->fRate != null){
                    $button1 = 'approved';
                }else{
                    $button1 ='bidNow';
                }
            }else{
                $button1 ='bidNow';
            }
            
            $BTFORWARD = order::formSaleFormA($this->id,$this->product,'forward');
            if($BTFORWARD != null){
                if($BTFORWARD->status == 'pending' && $BTFORWARD->fRate == null){
                    $button2 = 'update';
                }else if($BTFORWARD->status == 'pending' && $BTFORWARD->fRate != null){
                    $button2 = 'approved';
                }else{
                    $button2 ='bidNow';
                }
            }else{
                $button2 ='bidNow';
            }
        }
        //-------------------------------------------------------------------------------------------------
        // Musted MUSTARD Seed Button Settings
        if($this->MusterdSeedA['status'] == 'pending' && $this->MusterdSeedA['fRate'] == null){
            $MSA = 'update';
        }else if($this->MusterdSeedA['status'] == 'pending' && $this->MusterdSeedA['fRate'] != null){
            $MSA = 'approved';
        }else{
            $MSA ='bidNow';
        }//
        if($this->MusterdSeedB['status'] == 'pending' && $this->MusterdSeedB['fRate'] == null){
            $MSB = 'update';
        }else if($this->MusterdSeedB['status'] == 'pending' && $this->MusterdSeedB['fRate'] != null){
            $MSB = 'approved';
        }else{
            $MSB ='bidNow';
        }

        //-------------------------------------------------------------------------------------------------
        // Musted MUSTARD CAKE Button Settings
        if($this->MusterdCakeA['status'] == 'pending' && $this->MusterdCakeA['fRate'] == null){
            $MCKA = 'update';
        }else if($this->MusterdCakeA['status'] == 'pending' && $this->MusterdCakeA['fRate'] != null){
            $MCKA = 'approved';
        }else{
            $MCKA ='bidNow';
        }//
        if($this->MusterdCakeB['status'] == 'pending' && $this->MusterdCakeB['fRate'] == null){
            $MCKB = 'update';
        }else if($this->MusterdCakeB['status'] == 'pending' && $this->MusterdCakeB['fRate'] != null){
            $MCKB = 'approved';
        }else{
            $MCKB ='bidNow';
        }
        //-------------------------------------------------------------------------------------------------
        // Musted Solvent Seed Button Settings
        if($this->MusterdSolA['status'] == 'pending' && $this->MusterdSolA['fRate'] == null){
            $MSOLA = 'update';
        }else if($this->MusterdSolA['status'] == 'pending' && $this->MusterdSolA['fRate'] != null){
            $MSOLA = 'approved';
        }else{
            $MSOLA ='bidNow';
        }//
        if($this->MusterdSolB['status'] == 'pending' && $this->MusterdSolB['fRate'] == null){
            $MSOLB = 'update';
        }else if($this->MusterdSolB['status'] == 'pending' && $this->MusterdSolB['fRate'] != null){
            $MSOLB = 'approved';
        }else{
            $MSOLB ='bidNow';
        }

        return [
            'id' => $this->id,
            'productId' => $this->productData == '' ? '' : $this->productData->id,
            'productName' => $this->productData == '' ? '' : $this->productData->name,
            'productForm' => $this->productData == '' ? '' : $this->productData->pF,
            'productNature' => $this->productData == '' ? '' : $this->productData->nature,
            'productCondition' => $this->productData == '' ? '' : $this->productData->aConditions,
            'conditionRate' => $this->conditionRate == null || $this->conditionRate == null ? '0' : $this->conditionRate,
            'nonConditionRate' => $this->nonConditionRate == null || $this->nonConditionRate == null ? '0' : $this->nonConditionRate,
            'readyRate' => $this->readyRate == null || $this->readyRate == null ? '0' : $this->readyRate,
            'forwardRate' => $this->forwardRate == null || $this->forwardRate == null ? '0' : $this->forwardRate,
            'looseRatePbHr' => $this->looseRatePbHr == null || $this->looseRatePbHr == null ? '0' : $this->looseRatePbHr,
            'looseRateSumerpur' => $this->looseRateSumerpur == null || $this->looseRateSumerpur == null ? '0' : $this->looseRateSumerpur,
            'readyLiftingIn' => $this->validateDate($this->readyLiftingIn) ? date("d/m/y", strtotime($this->readyLiftingIn)) : $this->readyLiftingIn,
            'forwardLiftingIn' =>  $this->validateDate($this->forwardLiftingIn) ? date("d/m/y", strtotime($this->forwardLiftingIn)) : $this->forwardLiftingIn,
            'forForwardCday' => $this->forForwardCday,
            'MDAId' => $this->MusterdDocA['id'],
            'MDBId' => $this->MusterdDocB['id'],
            'MDCId' => $this->MusterdDocC['id'],
            'MDDId' => $this->MusterdDocD['id'],
            'MRAId' => $this->MusterdRefA['id'],
            'MRBId' => $this->MusterdRefB['id'],
            'MSAId' => $this->MusterdSeedA['id'],
            'MSBId' => $this->MusterdSeedB['id'],
            'MCKAId' => $this->MusterdCakeA['id'],
            'MCKBId' => $this->MusterdCakeB['id'],
            'MSOLAId' => $this->MusterdSolA['id'],
            'MSOLBId' => $this->MusterdSolB['id'],
            'MDA' => $MDA,
            'MDB' => $MDB,
            'MDC' => $MDC,
            'MDD' => $MDD,
            'buttonAId' => $this->productData->pF == 'SaleFormA' && $BTREADY !=null  ? $BTREADY->id : 0,
            'buttonBId' =>  $this->productData->pF == 'SaleFormA' && $BTFORWARD !=null ? $BTFORWARD->id : 0,
            'buttonA' => $this->productData->pF == 'SaleFormA' ? $button1 : 'bidNow',
            'buttonB' => $this->productData->pF == 'SaleFormA' ? $button2 : 'bidNow',
            'MSA' => $MSA,
            'MSB' => $MSB,
            'MCKA' => $MCKA,
            'MCKB' => $MCKB,
            'MSOLA' => $MSOLA,
            'MSOLB' => $MSOLB,
            'forReadyRate' => isset($forReadyRate) ? number_format((float)$forReadyRate, 2, '.', '') : '',
            'forForwardRate' => isset($forForwardRate) ? number_format((float)$forForwardRate, 2, '.', '') : '',
            'locationId' =>  isset($data) ? $data->id : '',
            'forReadyCday' => $this->forReadyCday,
            'CreatedAt' => date("d/m/y, h:i a", strtotime($this->created_at)),
        ];
    }
}
