<?php

namespace App\Http\Resources;
use App\Models\Location;
use App\Models\Order;

use Illuminate\Http\Resources\Json\JsonResource;

class DailyUpdateBackend extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
     public function validateDate($date, $format = 'Y-m-d'){
        $d = \DateTime::createFromFormat($format, $date);
        return $d && $d->format($format) == $date;
    }
    public function toArray($request)
    {
        if($this->productData->pF == 'SaleFormB' || $this->productData->pF == 'SaleFormA'){
            $counterA = Order::readyCount($this->id,$this->productData->id);
            $counterB = Order::forwardCount($this->id,$this->productData->id);
        }
        if($this->productData->pF == 'PurchaseFormA'){
            $counterA = Order::condCount($this->id,$this->productData->id);
            $counterB = Order::nonCondCount($this->id,$this->productData->id);
        }
        if($this->productData->pF == 'PurchaseFormB'){
            $counterA = Order::solCondCount($this->id,$this->productData->id);
            $counterB = Order::solNonCondCount($this->id,$this->productData->id);
        }
        if($this->productData->pF == 'PurchaseFormC'){
            $counterA = Order::pbHrCount($this->id,$this->productData->id);
            $counterB = Order::sumerpurCount($this->id,$this->productData->id);
        }









        if($this->locationId !=''){
            $data = Location::LocdataById($this->locationId);
                //$forForwardRate = '';
                //$forReadyRate = '';
            if($this->productData->pF == 'SaleFormB'){
                $forReadyRate = $this->readyRate == 0 ||$this->readyRate == null ? 0 : $this->readyRate +  $data->interest + $data->loadingCarges + $data->freight + $data->other + $data->gst;
                $forForwardRate = $this->forwardRate == 0 || $this->forwardRate == null ? 0 : $this->forwardRate +  $data->interest + $data->loadingCarges + $data->freight + $data->other + $data->gst;
            }
            }else{
                $data = Location::Locdata();
                    //$forForwardRate = '';
                    //$forReadyRate = '';
                if($this->productData->pF == 'SaleFormB'){
                    $forReadyRate = $this->readyRate == 0 ||$this->readyRate == null ? 0 : $this->readyRate +  $data->interest + $data->loadingCarges + $data->freight + $data->other + $data->gst;
                    $forForwardRate = $this->forwardRate == 0 || $this->forwardRate == null ? 0 : $this->forwardRate +  $data->interest + $data->loadingCarges + $data->freight + $data->other + $data->gst;
                }
            }
        return [
            'id' => $this->id,
            'productId' => $this->productData == '' ? '' : $this->productData->id,
            'productName' => $this->productData == '' ? '' : $this->productData->name,
            'productForm' => $this->productData == '' ? '' : $this->productData->pF,
            'productNature' => $this->productData == '' ? '' : $this->productData->nature,
            'productCondition' => $this->productData == '' ? '' : $this->productData->aConditions,
            'conditionRate' => $this->conditionRate,
            'nonConditionRate' => $this->nonConditionRate,
            'readyRate' => $this->readyRate,
            'forwardRate' => $this->forwardRate,
            'looseRatePbHr' => $this->looseRatePbHr,
            'looseRateSumerpur' => $this->looseRateSumerpur,
            'readyLiftingIn' => $this->readyLiftingIn,
            'forwardLiftingIn' => $this->forwardLiftingIn,
            'forForwardCday' => $this->forForwardCday,
            'forReadyCday' => $this->forReadyCday,
            'createdBy' => $this->userData == null || $this->userData == '' ? 'ANONYMOUS' : $this->userData->name,
            'forReadyRate' => isset($forReadyRate) ? number_format((float)$forReadyRate, 2, '.', '') : '',
            'forForwardRate' => isset($forForwardRate) ? number_format((float)$forForwardRate, 2, '.', '') : '',
            'counterA' => $counterA,
            'counterB' => $counterB,
            'CreatedAt' => date("d M, h:i a", strtotime($this->created_at)),
            'readyLIn' => $this->validateDate($this->readyLiftingIn) ? date("d/m/y", strtotime($this->readyLiftingIn)) : $this->readyLiftingIn,
            'forwardLIn' =>  $this->validateDate($this->forwardLiftingIn) ? date("d/m/y", strtotime($this->forwardLiftingIn)) : $this->forwardLiftingIn,
        ];
    }
}
