<?php

namespace App\Http\Resources;
use App\Models\Location;
use App\Models\Order;
use App\Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class DashboardBackend extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function validateDate($date, $format = 'Y-m-d'){
        $d = \DateTime::createFromFormat($format, $date);
        return $d && $d->format($format) == $date;
    }

    public function toArray($request)
    {
        $OrderStatus = Order::getstatus($this->id) == '' ? '' : Order::getstatus($this->id)->open;
        $OrderapStatus = Order::getapprovedstatus($this->id) == '' ? '' : Order::getapprovedstatus($this->id)->open;
        $apCount = Order::approveCount($this->productData->id);
        $pCount = Order::pendingCount($this->productData->id);
        $napCount = Order::napCount($this->productData->id);

        if($this->productData->pF == 'SaleFormB' || $this->productData->pF == 'SaleFormA'){
            $counterA = Order::readyCount($this->id,$this->productData->id);
            $counterB = Order::forwardCount($this->id,$this->productData->id);
        }
        if($this->productData->pF == 'PurchaseFormA'){
            $counterA = Order::condCount($this->id,$this->productData->id);
            $counterB = Order::nonCondCount($this->id,$this->productData->id);
        }
        if($this->productData->pF == 'PurchaseFormB'){
            $counterA = Order::solCondCount($this->id,$this->productData->id);
            $counterB = Order::solNonCondCount($this->id,$this->productData->id);
        }
        if($this->productData->pF == 'PurchaseFormC'){
            $counterA = Order::pbHrCount($this->id,$this->productData->id);
            $counterB = Order::sumerpurCount($this->id,$this->productData->id);
        }
        if($this->locationId !=''){
            $data = Location::LocdataById($this->locationId);
                //$forForwardRate = '';
                //$forReadyRate = '';
            if($this->productData->pF == 'SaleFormB'){
                $forReadyRate = $this->readyRate == 0 ||$this->readyRate == null ? 0 : $this->readyRate +  $data->interest + $data->loadingCarges + $data->freight + $data->other + $data->gst;
                $forForwardRate = $this->forwardRate == 0 || $this->forwardRate == null ? 0 : $this->forwardRate +  $data->interest + $data->loadingCarges + $data->freight + $data->other + $data->gst;
            }
            }else{
                $data = Location::Locdata();
                    //$forForwardRate = '';
                    //$forReadyRate = '';
                if($this->productData->pF == 'SaleFormB'){
                    $forReadyRate = $this->readyRate == 0 ||$this->readyRate == null ? 0 : $this->readyRate +  $data->interest + $data->loadingCarges + $data->freight + $data->other + $data->gst;
                    $forForwardRate = $this->forwardRate == 0 || $this->forwardRate == null ? 0 : $this->forwardRate +  $data->interest + $data->loadingCarges + $data->freight + $data->other + $data->gst;
                }
            }
        return [
            'id' => $this->id,
            'productId' => $this->productData == '' ? '' : $this->productData->id,
            'productName' => $this->productData == '' ? '' : $this->productData->name,
            'productForm' => $this->productData == '' ? '' : $this->productData->pF,
            'productNature' => $this->productData == '' ? '' : $this->productData->nature,
            'productCondition' => $this->productData == '' ? '' : $this->productData->aConditions,
            'conditionRate' => $this->conditionRate == null || $this->conditionRate == null ? 0 : $this->conditionRate,
            'nonConditionRate' => $this->nonConditionRate == null || $this->nonConditionRate == null ? 0 : $this->nonConditionRate,
            'readyRate' => $this->readyRate == null || $this->readyRate == null ? 0 : $this->readyRate,
            'forwardRate' => $this->forwardRate == null || $this->forwardRate == null ? 0 : $this->forwardRate,
            'looseRatePbHr' => $this->looseRatePbHr == null || $this->looseRatePbHr == null ? 0 : $this->looseRatePbHr,
            'looseRateSumerpur' => $this->looseRateSumerpur == null || $this->looseRateSumerpur == null ? 0 : $this->looseRateSumerpur,
            'readyLiftingIn' => $this->validateDate($this->readyLiftingIn) ? date("d/m/y", strtotime($this->readyLiftingIn)) : $this->readyLiftingIn,
            'forwardLiftingIn' =>  $this->validateDate($this->forwardLiftingIn) ? date("d/m/y", strtotime($this->forwardLiftingIn)) : $this->forwardLiftingIn,
            'forForwardCday' => $this->forForwardCday,
            'forReadyCday' => $this->forReadyCday,
            'createdBy' => $this->userData == null || $this->userData == '' ? 'anonymous' : $this->userData->name,
            'forReadyRate' => isset($forReadyRate) ? number_format((float)$forReadyRate, 2, '.', '') : '',
            'forForwardRate' => isset($forForwardRate) ? number_format((float)$forForwardRate, 2, '.', '') : '',
            'counterA' => $counterA,
            'counterB' => $counterB,
            'apCount' => $apCount,
            'pCount' => $pCount,
            'napCount' => $napCount,
            'open' => $OrderStatus == 'notopen' ? true : false,
            'apopen' => $OrderapStatus == 'notopen' ? true : false,
            'locationId' =>  isset($data) ? $data->id : '',
            'CreatedAt' => date("d/m/y, h:i a", strtotime($this->created_at)),
        ];
    }
}
