<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class OrderPartyResources extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'order' => $this->order,
            'partyName' => $this->partyData->name,
            'partyLocation' => $this->partyData->location,
            'qty' => $this->qty,
            'orderId' => $this->orderId,
        ];
    }
}
