<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\OrderParty;

class PurchaseFormA extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $msgCondition = '';
        if($this->productData->pF == 'PurchaseFormA' ){
            if($this->conditionType == 'condition'){
                $msgCondition = $this->orderType.' 42% Condition ';
                $emsgCondition = '42% Condition '.$this->orderType.' +GST';
            }else{
                $msgCondition = $this->orderType.'-Non Condition';
                $emsgCondition = 'Non Condition '.$this->orderType.' +GST';
            }
        }
        if($this->productData->pF == 'PurchaseFormB' ){
            if($this->conditionType == 'solvent-condition'){
                $msgCondition = $this->orderType.' Solvent Condition';
                $emsgCondition = 'Solvent Condition '.$this->orderType.' +GST';
            }else{
                 $msgCondition = $this->orderType.' Non Solvent Condition';
                 $emsgCondition = 'Non Solvent Condition '.$this->orderType.' +GST';
            }
        }
        
        if($this->productData->pF == 'PurchaseFormC' ){
            if($this->conditionType == 'pb/hr'){
                $msgCondition = 'PB/HR, '.$this->orderType.'-LOOSE';
                $emsgCondition = 'PB/HR, LOOSE '.$this->orderType.' +GST';
            }else{
                 $msgCondition = 'Sumerpur, '.$this->orderType.'-LOOSE';
                 $emsgCondition = 'Sumerpur, LOOSE '.$this->orderType.' +GST';
            }
        }
        
        if($this->productData->pF == 'SaleFormA' ){
            if($this->conditionType == 'ready'){
                $msgCondition = $this->orderType. ' LOOSE-READY';
                $emsgCondition = 'LOOSE-READY '.$this->orderType.' +GST';
            }else{
                 $msgCondition = $this->orderType. ' LOOSE-FORWARD';
                 $emsgCondition = 'LOOSE-FORWARD '.$this->orderType.' +GST';
            }
        }
        
        if($this->productData->pF == 'SaleFormB' ){
            if($this->conditionType == 'ready'){
                $msgCondition = $this->orderType.'-READY';
                $emsgCondition = 'READY '.$this->orderType.' +GST';
            }else{
                 $msgCondition = $this->orderType.'-FORWARD';
                 $emsgCondition = 'FORWARD '.$this->orderType.' +GST';
            }
        }
        return [
            'id' => $this->id,
            'bargainNo' => $this->bargainNo,
            'productName' => $this->productData->name,
            'productNature' => $this->productData->nature,
            'termCondition' => $this->productData->tC,
            'productForm' => $this->productData->pF,
            // Product data
            'msgCondition' => $msgCondition,
            'emsgCondition' => $emsgCondition,
            'orderType' => $this->orderType,
            'conditionType' => $this->conditionType,
            'oilContent' => $this->oilContent,
            'oQty' => $this->oQty,
            'fQty' => $this->fQty,
            'oRate' =>  $this->oRate,
            'dRate' =>  $this->dRate,
            'fRate' =>  $this->fRate,
            'bdType' => $this->bdType,
            'bdBy' => $this->bdBy,
            'katta' => $this->katta,
            'mandiTax' => $this->mandiTax,
            'labourCharges' => $this->labourCharges,
            'loadingCharges' => $this->loadingCharges,
            'freight' => $this->freight,
            'location' => $this->location,
            'fLoadingDate' => $this->status == 'approved' ? date("d/m/Y", strtotime($this->fLoadingDate)) : $this->fLoadingDate,
            'fPaymentDate' => $this->status == 'approved' ? date("d/m/Y", strtotime($this->fPaymentDate)) : $this->fPaymentDate,
            'status' => $this->status,
            'createdAt' => date("d/m/Y H:i", strtotime($this->created_at)),
            'updatedAt' => $this->updated_at == null ? '-' : date("d/m/Y H:i", strtotime($this->updated_at)),
            'customer' => $this->orderBy == '' ? '' : $this->orderBy->name,
            'customerEmail' => $this->orderBy == '' ? '' : $this->orderBy->email,
            'partyName' => $this->orderBy == '' ? '' : $this->orderBy->company,
            'pQty' => $this->fQty - OrderParty::totalQty($this->id),
            'manageBy' => $this->orderManageBy == '' ? '' : $this->orderManageBy->name,
        ];
    }
}
