<?php

namespace App\Http\Resources;
use App\Models\Order;

use Illuminate\Http\Resources\Json\JsonResource;

class ReportManager extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $data = Order::orderParty($this->id);
        return [
            'id' => $this->id,
            'orderDate' => date("d/m/Y", strtotime($this->created_at)),
            'bargainNo' => $this->bargainNo,
            'partyName' => $this->orderBy->company == '' || $this->orderBy->company == null ? $this->orderBy->name : $this->orderBy->company,
            'orderparty' => $data,
            'product' => $this->productData->name,
            'qty' => $this->fQty,
            'rate' => $this->fRate,
            'condition' => $this->conditionType,
            'orderType' => $this->orderType,
            'finalDate' => date("d/m/Y", strtotime($this->updated_at)),
            'broker' => $this->orderBy->name,
        ];
    }
}
