<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\OrderParty;

class SaleFormB extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'bargainNo' => $this->bargainNo,
            'productName' => $this->productData->name,
            'productNature' => $this->productData->nature,
            'termCondition' => $this->productData->tC,
            // Product data
            'orderType' => strtoupper($this->orderType),
            'conditionType' => strtoupper($this->conditionType),
            'oQty' => $this->oQty,
            'fQty' => $this->fQty,
            'oRate' =>  $this->oRate,
            'dRate' =>  $this->dRate,
            'fRate' =>  $this->fRate,
            'location' => $this->location,
            'paymentCond' => $this->paymentCond == 'Advance' ? $this->paymentCond : $this->paymentCond.' Days Credit',
            'oLoadingDate' => $this->status == 'approved' ? date("d/m/Y", strtotime($this->oLoadingDate)) : $this->oLoadingDate,
            'fLoadingDate' => $this->status == 'approved' ? date("d/m/Y", strtotime($this->fLoadingDate)) : $this->fLoadingDate,
            'oPaymentDate' => $this->status == 'approved' ? date("d/m/Y", strtotime($this->oPaymentDate)) : $this->oPaymentDate,
            'fPaymentDate' => $this->status == 'approved' ? date("d/m/Y", strtotime($this->fPaymentDate)) : $this->fPaymentDate,
            'status' => $this->status,
            'createdAt' => date("d/m/Y H:i", strtotime($this->created_at)),
            'updatedAt' => $this->updated_at == null ? '-' : date("d/m/Y H:i", strtotime($this->updated_at)),
            'customer' => $this->orderBy == '' ? '' : $this->orderBy->name,
            'pQty' => $this->fQty - OrderParty::totalQty($this->id),
            'manageBy' => $this->orderManageBy == '' ? '' : $this->orderManageBy->name,
        ];
    }
}
