<?php

namespace App\Http\Resources;
use App\Models\Product;

use Illuminate\Http\Resources\Json\JsonResource;

class UserData extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'productData' => Product::productName($this->product),
            'name' => $this->name,
            'company' => $this->company == null || $this->company == '' ? $this->name : $this->company,
            'email' => $this->email,
            'username' => $this->username,
            'phone' => $this->phone,
            'product' => $this->product,
            'role' => $this->role,
            'status' => $this->status
        ];
    }
}
