<?php

namespace App\Http\Resources;
use App\Models\Product;
use Illuminate\Http\Resources\Json\JsonResource;

class UserInfo extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'name' => $this->name,
            'email' => $this->email,
            'productData' => Product::productName($this->product),
            'company' => $this->company == null || $this->company == '' ? $this->name : $this->company,
            'username' => $this->username,
            'phone' => $this->phone,
            'product' => $this->product,
            'role' => $this->role,
        ];
    }
}
