<?php

namespace App\Models;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Model;

class DailyUpdate extends Model
{
    protected $table = 'dailyupdates';
    public function productData(){
        return $this->belongsTo('App\Models\Product','product');
        //return $this->belongsTo(Media::class);
    }
    public function userData(){
        return $this->belongsTo('App\Models\User','generatedBy');
        //return $this->belongsTo(Media::class);
    }
    public function orderData(){
        return $this->belongsTo('App\Models\Order','id','updateId')->where('customer',auth('sanctum')->user()->id)->orderBy('created_at','desc')->take(1);
        //return $this->belongsTo(Media::class);
    }
    /*public function ordercounter(){
        return '';
        //return $this->belongsTo(Media::class);
    }*/
    // Musterd DOC Button setting
    public function MusterdDocA(){
        return $this->belongsTo('App\Models\Order','id','updateId')->where('customer',auth('sanctum')->user()->id)
        ->where('orderType','EX')
        ->where('conditionType','ready')
        ->whereNotNull('paymentCond')
        ->orderBy('created_at','desc')->take(1);
    }
    public function MusterdDocB(){
        return $this->belongsTo('App\Models\Order','id','updateId')->where('customer',auth('sanctum')->user()->id)
        ->where('orderType','EX')
        ->where('conditionType','forward')
        ->whereNotNull('paymentCond')
        ->orderBy('created_at','desc')->take(1);
    }
    public function MusterdDocC(){
        return $this->belongsTo('App\Models\Order','id','updateId')->where('customer',auth('sanctum')->user()->id)
        ->where('orderType','FOR')
        ->where('conditionType','ready')
        ->whereNotNull('paymentCond')
        ->orderBy('created_at','desc')->take(1);
    }
    public function MusterdDocD(){
        return $this->belongsTo('App\Models\Order','id','updateId')->where('customer',auth('sanctum')->user()->id)
        ->where('orderType','FOR')
        ->where('conditionType','forward')
        ->whereNotNull('paymentCond')
        ->orderBy('created_at','desc')->take(1);
    }

    // MUSTARD REFINED
    public function MusterdRefA(){
        return $this->belongsTo('App\Models\Order','id','updateId')->where('customer',auth('sanctum')->user()->id)
        ->where('orderType','FOR')
        ->where('conditionType','ready')
        ->whereNull('paymentCond')
        ->orderBy('created_at','desc')->take(1);
    }
    public function MusterdRefB(){
        return $this->belongsTo('App\Models\Order','id','updateId')->where('customer',auth('sanctum')->user()->id)
        ->where('orderType','FOR')
        ->where('conditionType','forward')
        ->whereNull('paymentCond')
        ->orderBy('created_at','desc')->take(1);
    }

    // MUSTARD Seed
    public function MusterdSeedA(){
        return $this->belongsTo('App\Models\Order','id','updateId')->where('customer',auth('sanctum')->user()->id)
        ->where('orderType','FOR')
        ->where('conditionType','condition')
        ->whereNull('paymentCond')
        ->orderBy('created_at','desc')->take(1);
    }
    public function MusterdSeedB(){
        return $this->belongsTo('App\Models\Order','id','updateId')->where('customer',auth('sanctum')->user()->id)
        ->whereIn('orderType',['EX','FOR','LP'])
        ->where('conditionType','non-condition')
        ->whereNull('paymentCond')
        ->orderBy('created_at','desc')->take(1);
    }

    // MUSTARD Solvent
    public function MusterdCakeA(){
        return $this->belongsTo('App\Models\Order','id','updateId')->where('customer',auth('sanctum')->user()->id)
        ->where('orderType','FOR')
        ->where('conditionType','solvent-condition')
        ->whereNull('paymentCond')
        ->orderBy('created_at','desc')->take(1);
    }
    public function MusterdCakeB(){
        return $this->belongsTo('App\Models\Order','id','updateId')->where('customer',auth('sanctum')->user()->id)
        ->where('orderType','FOR')
        ->where('conditionType','solvent-non-condition')
        ->whereNull('paymentCond')
        ->orderBy('created_at','desc')->take(1);
    }

    // MUSTARD Solvent
    public function MusterdSolA(){
        return $this->belongsTo('App\Models\Order','id','updateId')->where('customer',auth('sanctum')->user()->id)
        ->whereIn('orderType',['FOR','EX'])
        ->where('conditionType','pb/hr')
        ->whereNull('paymentCond')
        ->orderBy('created_at','desc')->take(1);
    }
    public function MusterdSolB(){
        return $this->belongsTo('App\Models\Order','id','updateId')->where('customer',auth('sanctum')->user()->id)
        ->whereIn('orderType',['FOR','EX'])
        ->where('conditionType','sumerpur')
        ->whereNull('paymentCond')
        ->orderBy('created_at','desc')->take(1);
    }
}
