<?php

namespace App\Models;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use App\Models\OrderParty;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    public $timestamps = false;
    
    public function dailyUpdate(){
        return $this->belongsTo('App\Models\DailyUpdate','updateId');
    }
    public function productData(){
        return $this->belongsTo('App\Models\Product','product')->orderBy('nature', 'desc');
    }
    public function orderManageBy(){
        return $this->belongsTo('App\Models\User','manageBy');
    }
    public function orderBy(){
        return $this->belongsTo('App\Models\User','customer');
    }
     public static function orderParty($id) {
        return OrderParty::where('order',$id)
        ->join('orders', 'orders.id', '=', 'order_parties.order' )
        ->join('broker_parties', 'broker_parties.id', '=', 'order_parties.party')
        ->join('users', 'users.id', '=', 'orders.customer')
        ->join('products', 'products.id', '=', 'orders.product')
        ->select('order_parties.*', 'orders.fRate as partyRate','orders.conditionType as partyCon', \DB::raw('DATE_FORMAT(orders.created_at, "%d/%m/%Y") as createDate'), \DB::raw('DATE_FORMAT(orders.updated_at, "%d/%m/%Y") as finalDate'), 'orders.orderType as partyOrderTy','broker_parties.name as partyName','products.name as product','users.name as broker', 'broker_parties.location as partyLocation')->get();
       //return $this->hasMany('App\Models\OrderParty','order','id')->hasOne('App\Models\BrokerParty','party','id');
    }
    public static function getstatus($updateId){
        return Order::where('updateId',$updateId)->where('status','pending')->orderBy('created_at','desc')->first();
    }
    public static function getapprovedstatus($updateId){
        return Order::where('updateId',$updateId)->where('status','approved')->orderBy('updated_at','desc')->first();
    }
    // Approve Counter
    public static function approveCount($productId){
        return Order::whereDate('created_at', Carbon::today())->where('product',$productId)->where('status','approved')->get()->count();
    }
    // Pending Countert
    public static function pendingCount($productId){
        return Order::whereDate('created_at', Carbon::today())->where('product',$productId)->where('status','pending')->get()->count();
    }
    //Not Approved CounterCarbon::now()->addDay(-1)
    public static function napCount($productId){
        return Order::whereDate('created_at', Carbon::now()->addDay(-1))->where('product',$productId)->where('status','notapproved')->get()->count();
    }
    public static function readyCount($updateId,$productId){
        return Order::where('updateId',$updateId)->where('product',$productId)->where('conditionType','ready')->where('status','pending')->get()->count();
    }
    public static function forwardCount($updateId,$productId){
        return Order::where('updateId',$updateId)->where('product',$productId)->where('conditionType','forward')->where('status','pending')->get()->count();
    }
    public static function condCount($updateId,$productId){
        return Order::where('updateId',$updateId)->where('product',$productId)->where('conditionType','condition')->where('status','pending')->get()->count();
    }
    public static function nonCondCount($updateId,$productId){
        return Order::where('updateId',$updateId)->where('product',$productId)->where('conditionType','non-condition')->where('status','pending')->get()->count();
    }
    public static function solCondCount($updateId,$productId){
        return Order::where('updateId',$updateId)->where('product',$productId)->where('conditionType','solvent-condition')->where('status','pending')->get()->count();
    }
    public static function solNonCondCount($updateId,$productId){
        return Order::where('updateId',$updateId)->where('product',$productId)->where('conditionType','solvent-non-condition')->where('status','pending')->get()->count();
    }
    public static function pbHrCount($updateId,$productId){
        return Order::where('updateId',$updateId)->where('product',$productId)->where('conditionType','pb/hr')->where('status','pending')->get()->count();
    }
    public static function sumerpurCount($updateId,$productId){
        return Order::where('updateId',$updateId)->where('product',$productId)->where('conditionType','sumerpur')->where('status','pending')->get()->count();
    }
    public static function formSaleFormA($updateId,$productId,$conditionType){
        return Order::where('updateId',$updateId)->where('product',$productId)->where('conditionType',$conditionType)->where('customer',auth('sanctum')->user()->id)->orderBy('created_at','desc')->first();
    }
}

