<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    protected $table = 'products';
    public function Updates(){
        return $this->hasManyThrough('App\Models\DailyUpdate')->orderBy('nature', 'desc');;
    }
    public function order(){
        return $this->hasManyThrough('App\Models\Order');
    }
    public static function productName($data){
        if($data != null || $data != ''){
            $product = explode(',',$data);
            return Product::whereIn('id',$product)->select('name')->get();
        }
        else{
            return Product::whereIn('id',$data)->select('name')->get();
        }
    }
}
