<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use App\Order;
use Illuminate\Notifications\Messages\BroadcastMessage;
class ApprovedNotification extends Notification
{
    public $Order;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(Order $order)
    {
        $this->Order = $order;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    
    public function via($notifiable)
    {
        return ['database','broadcast'];
    }
    
    public function toArray($notifiable)
    {
        return [
            'updateItem' => $this->Order->productData->name,
            'productId' => $this->Order->productData->id,
            'notificationType' => 'approveOrder',
            'createdAt' => date("Y-m-d H:i:s"),
            'message' => 'Bargain No. "'.$this->Order->bargainNo.'" Approved by '.$this->Order->orderBy->name,
            'customer' => $this->Order->orderBy == '' ? '' : $this->Order->orderBy->name,
            'update' => $this->Order,
        ];
    }
    public function toBroadcast($notifiable)
    {
        return new BroadcastMessage([
            'updateItem' => $this->Order->productData->name,
            'productId' => $this->Order->productData->id,
            'notificationType' => 'approveOrder',
            'message' => 'Bargain No. "'.$this->Order->bargainNo.'" Approved by '.$this->Order->orderBy->name,
            'customer' => $this->Order->orderBy == '' ? '' : $this->Order->orderBy->name,
            'update' => $this->Order,
        ]);
    }
}
