<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use App\DailyUpdate;
use App\Http\Resources\DailyUpdateBackend;
use Illuminate\Notifications\Messages\BroadcastMessage;

class UpdateNotification extends Notification
{
    use Queueable;

    public $DailyUpdate;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(DailyUpdate $DailyUpdate)
    {
        $this->DailyUpdate = $DailyUpdate;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['database','broadcast'];
    }
    public function setMessage($data){
        if($data->productData->pF == 'SaleFormA'){
            if(($data->readyRate == 0 && $data->forwardRate == 0 ) || ($data->readyRate ==   NULL && $data->forwardRate == NULL)){
                return 'Sale Has been closed.';
            }else{
                return 'New bid has update. Bid Now';
            }
        }
        if($data->productData->pF == 'SaleFormB'){
            if(($data->readyRate == 0 && $data->forwardRate == 0 ) || ($data->readyRate ==   NULL && $data->forwardRate == NULL)){
                return 'Sale has Closed.';
            }else{
                return 'New bid has update. Bid Now';
            }
        }
        if($data->productData->pF == 'PurchaseFormA'){
            if(($data->conditionRate == 0 && $data->nonConditionRate == 0 ) || ($data->conditionRate ==   NULL && $data->nonConditionRate == NULL)){
                return 'Purchase has Closed.';
            }else{
                return 'New bid has update. Bid Now';
            }
        }
        if($data->productData->pF == 'PurchaseFormB'){
            if(($data->conditionRate == 0 && $data->nonConditionRate == 0 ) || ($data->conditionRate ==   NULL && $data->nonConditionRate == NULL)){
                return 'Purchase has Closed.';
            }else{
                return 'New bid has update. Bid Now';
            }
        }
        if($data->productData->pF == 'PurchaseFormC'){
            if(($data->looseRatePbHr == 0 && $data->looseRateSumerpur == 0 ) || ($data->looseRatePbHr ==   NULL && $data->looseRateSumerpur == NULL)){
                return 'Purchase has Closed.';
            }else{
                return 'New bid has update. Bid Now';
            }
        }
    }

    public function toArray($notifiable)
    {
        return [
            'updateItem' => $this->DailyUpdate->productData->name,
            'notificationType' => 'updateNew',
            'createdAt' => date("Y-m-d H:i:s"),
            'message' => $this->setMessage($this->DailyUpdate),
            'update' => $this->DailyUpdate,
        ];
    }

    public function toBroadcast($notifiable)
    {
        return new BroadcastMessage([
            'updateItem' => $this->DailyUpdate->productData->name,
            'notificationType' => 'updateNew',
            'createdAt' => date("Y-m-d H:i:s"),
            'message' => $this->setMessage($this->DailyUpdate),
            'update' => $this->DailyUpdate,
        ]);
    }
}
