<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class DailyUpdate extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('dailyupdates', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('product');
            $table->double('conditionRate')->nullable();
            $table->double('nonConditionRate')->nullable();
            $table->double('readyRate')->nullable();
            $table->double('forwardRate')->nullable();
            $table->double('looseRatePbHr')->nullable();
            $table->double('looseRateSumerpur')->nullable();
            $table->string('readyLiftingIn')->nullable();
            $table->string('forwardLiftingIn')->nullable();
            $table->bigInteger('forReadyCday')->nullable();
            $table->bigInteger('forForwardCday')->nullable();
            $table->unsignedInteger('generatedBy')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dailyupdates');
    }
}
