<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->double('dRate')->nullable();
            $table->double('oRate')->nullable();
            $table->double('oQty')->nullable();
            $table->string('oPaymentDate')->nullable();
            $table->string('oLoadingDate')->nullable();
            $table->string('paymentCond')->nullable();
            $table->double('fRate')->nullable();
            $table->double('fQty')->nullable();
            $table->string('fPaymentDate')->nullable();
            $table->string('fLoadingDate')->nullable();
            $table->double('loadingCharges')->nullable();
            $table->double('freight')->nullable();
            $table->float('LabourCharges')->nullable();
            $table->float('mandiTax')->nullable();
            $table->string('location')->nullable();
            $table->string('katta')->nullable();
            $table->string('bdBy')->nullable();
            $table->string('bdType')->nullable();
            $table->string('status')->nullable();
            $table->timestamp('approvedAt')->nullable();
            $table->unsignedInteger('product');
            $table->unsignedInteger('updateId');
            $table->unsignedInteger('customer');
            $table->unsignedInteger('manageBy')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
