<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\TokenController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\LocationController;
use App\Http\Controllers\UnitController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\StateCitiesController;
use App\Http\Controllers\DailyUpdateController;
use App\Http\Controllers\DailySaleController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\PartyController;
use App\Http\Controllers\PartyAddressController;
use App\Http\Controllers\BrokerPartyController;
use App\Http\Controllers\OrderPartyController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Forgot Password
Route::post('/forgot/email/password', [TokenController::class, 'ForgotTokenGenrate']);
Route::post('/forgot/password/update', [TokenController::class, 'ForgotTokenCheck']);

// Login Info Logout
Route::post('/user/login', [UserController::class, 'Login']);
Route::middleware('auth:sanctum')->get('/user/info', [UserController::class, 'UserInfo'])->name('userinfo');
Route::middleware('auth:sanctum')->post('/user/logout', [UserController::class, 'Logout']);
Route::middleware('auth:sanctum')->post('/user/status', [UserController::class, 'statusUpdate']);

// Controller
Route::middleware('auth:sanctum')->put('/user/setting/update', [UserController::class, 'setting']);
Route::middleware('auth:sanctum')->get('/user/records', [UserController::class, 'index']);
Route::middleware('auth:sanctum')->post('/user/create', [UserController::class, 'store']);
Route::middleware('auth:sanctum')->put('/user/update', [UserController::class, 'store']);
Route::middleware('auth:sanctum')->get('/user/byid/{id}', [UserController::class, 'show']);
Route::middleware('auth:sanctum')->delete('/user/delete/{id}', [UserController::class, 'destroy']);

// Location
Route::middleware('auth:sanctum')->get('/location/records', [LocationController::class, 'index']);
Route::middleware('auth:sanctum')->get('/location/records/active', [LocationController::class, 'indexActive']);
Route::middleware('auth:sanctum')->post('/location/create', [LocationController::class, 'store']);
Route::middleware('auth:sanctum')->put('/location/update', [LocationController::class, 'store']);
Route::middleware('auth:sanctum')->get('/location/byid/{id}', [LocationController::class, 'show']);
Route::middleware('auth:sanctum')->delete('/location/delete/{id}', [LocationController::class, 'destroy']);

// Unit Controller
Route::middleware('auth:sanctum')->get('/unit/records', [UnitController::class, 'index']);
Route::middleware('auth:sanctum')->post('/unit/create', [UnitController::class, 'store']);
Route::middleware('auth:sanctum')->put('/unit/update', [UnitController::class, 'store']);
Route::middleware('auth:sanctum')->get('/unit/byid/{id}', [UnitController::class, 'show']);
Route::middleware('auth:sanctum')->delete('/unit/delete/{id}', [UnitController::class, 'destroy']);

// Product Controller
Route::middleware('auth:sanctum')->get('/product/records', [ProductController::class, 'index']);
Route::middleware('auth:sanctum')->post('/product/create', [ProductController::class, 'store']);
Route::middleware('auth:sanctum')->put('/product/update', [ProductController::class, 'store']);
Route::middleware('auth:sanctum')->get('/product/byid/{id}', [ProductController::class, 'show']);
Route::middleware('auth:sanctum')->get('/product/byuser', [ProductController::class, 'showbyUser']);
Route::middleware('auth:sanctum')->delete('/product/delete/{id}', [ProductController::class, 'destroy']);

// State And Cities
Route::middleware('auth:sanctum')->get('/state/records', [StateCitiesController::class, 'state']);
Route::middleware('auth:sanctum')->get('/city/byid/{id}', [StateCitiesController::class, 'city']);

// Purchase Controller
Route::middleware('auth:sanctum')->get('/dailyupdate/records', [DailyUpdateController::class, 'index']);
Route::middleware('auth:sanctum')->get('/dailyupdate/byid/{id}', [DailyUpdateController::class, 'show'])->name('singleupdate');
Route::middleware('auth:sanctum')->get('/dailyupdate/byid/{loaction}/{id}', [DailyUpdateController::class, 'showbyLocation']);
Route::middleware('auth:sanctum')->post('/dailyupdate/create', [DailyUpdateController::class, 'store']);
Route::middleware('auth:sanctum')->put('/dailyupdate/update', [DailyUpdateController::class, 'store']);
Route::middleware('auth:sanctum')->delete('/dailyupdate/delete/{id}', [DailyUpdateController::class, 'destroy']);

// Sales Controller
Route::middleware('auth:sanctum')->get('/sale/records', [DailySaleController::class, 'index']);
Route::middleware('auth:sanctum')->get('/sale/byid/{id}', [DailySaleController::class, 'show']);
Route::middleware('auth:sanctum')->post('/sale/create', [DailySaleController::class, 'store']);
Route::middleware('auth:sanctum')->put('/sale/update', [DailySaleController::class, 'store']);
Route::middleware('auth:sanctum')->delete('/sale/delete{id}', [DailySaleController::class, 'destroy']);

// Dashboard Controller
Route::middleware('auth:sanctum')->get('/backend/dashboard', [DashboardController::class, 'BackendDahsboard']);
Route::middleware('auth:sanctum')->get('/custmor/dashboard', [DashboardController::class, 'CustmorDahsboard']);
Route::middleware('auth:sanctum')->get('/backend/dashboard/{location}', [DashboardController::class, 'BackendDahsboardByLocation']);
Route::middleware('auth:sanctum')->get('/custmor/dashboard/{location}', [DashboardController::class, 'CustmorDahsboardByLocation']);

// Order Controller
Route::middleware('auth:sanctum')->get('/order/records', [OrderController::class, 'index']);
Route::middleware('auth:sanctum')->get('/order/open/product/{id}', [OrderController::class, 'openOrder']);
Route::middleware('auth:sanctum')->post('/order/create', [OrderController::class, 'create']);
Route::middleware('auth:sanctum')->put('/order/update', [OrderController::class, 'store']);
Route::middleware('auth:sanctum')->post('/order/approve', [OrderController::class, 'approveBid']);
Route::middleware('auth:sanctum')->post('/order/multiple/{id}', [OrderController::class, 'multiple'])->name('multipleorders');
Route::middleware('auth:sanctum')->post('/order/sendemail/{id}', [OrderController::class, 'sendByAdmin']);
Route::get('/order/update/data', [OrderController::class, 'makenap']);

// BACKEND USER SHOW ORDER BY FORMTYPE
Route::middleware('auth:sanctum')->get('/order/backend/purchaseforma/fetchbyid/{id}', [OrderController::class, 'showBackendPurchaseFormA']);
Route::middleware('auth:sanctum')->get('/order/backend/purchaseformb/fetchbyid/{id}', [OrderController::class, 'showBackendPurchaseFormB']);
Route::middleware('auth:sanctum')->get('/order/backend/purchaseformc/fetchbyid/{id}', [OrderController::class, 'showBackendPurchaseFormC']);
Route::middleware('auth:sanctum')->get('/order/backend/saleforma/fetchbyid/{id}', [OrderController::class, 'showBackendSaleFormA']);
Route::middleware('auth:sanctum')->get('/order/backend/saleformb/fetchbyid/{id}', [OrderController::class, 'showBackendSaleFormB']);

// Custmoer USER SHOW ORDER BY FORMTYPE
Route::middleware('auth:sanctum')->get('/order/customer/purchaseforma/fetchbyid/{id}', [OrderController::class, 'showCustomerPurchaseFormA']);
Route::middleware('auth:sanctum')->get('/order/customer/purchaseformb/fetchbyid/{id}', [OrderController::class, 'showCustomerPurchaseFormB']);
Route::middleware('auth:sanctum')->get('/order/customer/purchaseformc/fetchbyid/{id}', [OrderController::class, 'showCustomerPurchaseFormC']);
Route::middleware('auth:sanctum')->get('/order/customer/saleforma/fetchbyid/{id}', [OrderController::class, 'showCustomerSaleFormA']);
Route::middleware('auth:sanctum')->get('/order/customer/saleformb/fetchbyid/{id}', [OrderController::class, 'showCustomerSaleFormB']);

// SHOW ORDER BY FORMTYPE Single by id
Route::middleware('auth:sanctum')->get('/order/purchaseforma/fetchbyid/{id}', [OrderController::class, 'showByIdPurchaseFormA'])->name('orderbyid');
Route::middleware('auth:sanctum')->get('/order/purchaseformb/fetchbyid/{id}', [OrderController::class, 'showByIdPurchaseFormB']);
Route::middleware('auth:sanctum')->get('/order/purchaseformc/fetchbyid/{id}', [OrderController::class, 'showByIdPurchaseFormC']);
Route::middleware('auth:sanctum')->get('/order/saleforma/fetchbyid/{id}', [OrderController::class, 'showByIdSaleFormA']);
Route::middleware('auth:sanctum')->get('/order/saleformb/fetchbyid/{id}', [OrderController::class, 'showByIdSaleFormB']);

Route::middleware('auth:sanctum')->delete('/order/delete/{id}', [OrderController::class, 'destroy']);

// Customer
Route::middleware('auth:sanctum')->get('/customer/dashboard/counter/approved', [DashboardController::class, 'CustmorCounterApproved']);
Route::middleware('auth:sanctum')->get('/customer/dashboard/counter/pending', [DashboardController::class, 'CustmorCounterPending']);
Route::middleware('auth:sanctum')->get('/customer/dashboard/counter/submitted', [DashboardController::class, 'CustmorCounterSubmitted']);
Route::middleware('auth:sanctum')->get('/customer/dashboard/counter/notapproved', [DashboardController::class, 'CustmorCounterNotApproved']);

Route::middleware('auth:sanctum')->get('/order/customer/pending/purchaseforma/{id}', [OrderController::class, 'showCustomerPendingPurchaseFormA']);
Route::middleware('auth:sanctum')->get('/order/customer/pending/purchaseformb/{id}', [OrderController::class, 'showCustomerPendingPurchaseFormB']);
Route::middleware('auth:sanctum')->get('/order/customer/pending/purchaseformc/{id}', [OrderController::class, 'showCustomerPendingPurchaseFormC']);
Route::middleware('auth:sanctum')->get('/order/customer/pending/saleforma/{id}', [OrderController::class, 'showCustomerPendingSaleFormA']);
Route::middleware('auth:sanctum')->get('/order/customer/pending/saleformb/{id}', [OrderController::class, 'showCustomerPendingSaleFormB']);

Route::middleware('auth:sanctum')->get('/order/customer/approved/purchaseforma/{id}', [OrderController::class, 'showCustomerApprovedPurchaseFormA']);
Route::middleware('auth:sanctum')->get('/order/customer/approved/purchaseformb/{id}', [OrderController::class, 'showCustomerApprovedPurchaseFormB']);
Route::middleware('auth:sanctum')->get('/order/customer/approved/purchaseformc/{id}', [OrderController::class, 'showCustomerApprovedPurchaseFormC']);
Route::middleware('auth:sanctum')->get('/order/customer/approved/saleforma/{id}', [OrderController::class, 'showCustomerApprovedSaleFormA']);
Route::middleware('auth:sanctum')->get('/order/customer/approved/saleformb/{id}', [OrderController::class, 'showCustomerApprovedSaleFormB']);

Route::middleware('auth:sanctum')->get('/order/customer/notapproved/purchaseforma/{id}', [OrderController::class, 'showCustomerNotApprovedPurchaseFormA']);
Route::middleware('auth:sanctum')->get('/order/customer/notapproved/purchaseformb/{id}', [OrderController::class, 'showCustomerNotApprovedPurchaseFormB']);
Route::middleware('auth:sanctum')->get('/order/customer/notapproved/purchaseformc/{id}', [OrderController::class, 'showCustomerNotApprovedPurchaseFormC']);
Route::middleware('auth:sanctum')->get('/order/customer/notapproved/saleforma/{id}', [OrderController::class, 'showCustomerNotApprovedSaleFormA']);
Route::middleware('auth:sanctum')->get('/order/customer/notapproved/saleformb/{id}', [OrderController::class, 'showCustomerNotApprovedSaleFormB']);

// Customer Party
Route::middleware('auth:sanctum')->get('/party/records', [PartyController::class, 'index']);
Route::middleware('auth:sanctum')->post('/party/create', [PartyController::class, 'store']);
Route::middleware('auth:sanctum')->put('/party/update', [PartyController::class, 'store']);
Route::middleware('auth:sanctum')->get('/party/byid/{id}', [PartyController::class, 'show']);
Route::middleware('auth:sanctum')->delete('/party/delete/{id}', [PartyController::class, 'destroy']);

// Party Address
Route::middleware('auth:sanctum')->get('/customer/party/address/{id}/records', [PartyAddressController::class, 'index']);
Route::middleware('auth:sanctum')->post('/customer/party/address/create', [PartyAddressController::class, 'store']);
Route::middleware('auth:sanctum')->put('/customer/party/address/update', [PartyAddressController::class, 'store']);
Route::middleware('auth:sanctum')->put('/customer/party/address/fetchbyid/{id}', [PartyAddressController::class, 'show']);

// BrokerParty Controller
Route::middleware('auth:sanctum')->get('/broker/party/records', [BrokerPartyController::class, 'index']);
Route::middleware('auth:sanctum')->post('/broker/party/create', [BrokerPartyController::class, 'store']);
Route::middleware('auth:sanctum')->put('/broker/party/update', [BrokerPartyController::class, 'store']);
Route::middleware('auth:sanctum')->get('/broker/party/byid/{id}', [BrokerPartyController::class, 'show']);

// BrokerParty Controller
Route::middleware('auth:sanctum')->get('/order/party/records/{id}', [OrderPartyController::class, 'index'])->name('orderparty');
Route::middleware('auth:sanctum')->get('/order/party/byid/{id}', [OrderPartyController::class, 'show'])->name('partybyidinorder');
Route::middleware('auth:sanctum')->get('/order/party/bymultipleid/{id}', [OrderPartyController::class, 'bymultiple'])->name('multiorderparty');
Route::middleware('auth:sanctum')->post('/order/party/create', [OrderPartyController::class, 'store']);
Route::middleware('auth:sanctum')->delete('/broker/party/delete/{id}', [OrderPartyController::class, 'destroy']);

// Backend
Route::middleware('auth:sanctum')->get('/order/backend/pending/purchaseforma/{id}', [OrderController::class, 'showbackEndPendingPurchaseFormA']);
Route::middleware('auth:sanctum')->get('/order/backend/pending/purchaseformb/{id}', [OrderController::class, 'showbackEndPendingPurchaseFormB']);
Route::middleware('auth:sanctum')->get('/order/backend/pending/purchaseformc/{id}', [OrderController::class, 'showbackEndPendingPurchaseFormC']);
Route::middleware('auth:sanctum')->get('/order/backend/pending/saleforma/{id}', [OrderController::class, 'showbackEndPendingSaleFormA']);
Route::middleware('auth:sanctum')->get('/order/backend/pending/saleformb/{id}', [OrderController::class, 'showbackEndPendingSaleFormB']);

Route::middleware('auth:sanctum')->get('/order/backend/approved/purchaseforma/{id}', [OrderController::class, 'showbackEndApprovedPurchaseFormA']);
Route::middleware('auth:sanctum')->get('/order/backend/approved/purchaseformb/{id}', [OrderController::class, 'showbackEndApprovedPurchaseFormB']);
Route::middleware('auth:sanctum')->get('/order/backend/approved/purchaseformc/{id}', [OrderController::class, 'showbackEndApprovedPurchaseFormC']);
Route::middleware('auth:sanctum')->get('/order/backend/approved/saleforma/{id}', [OrderController::class, 'showbackEndApprovedSaleFormA']);
Route::middleware('auth:sanctum')->get('/order/backend/approved/saleformb/{id}', [OrderController::class, 'showbackEndApprovedSaleFormB']);

Route::middleware('auth:sanctum')->get('/order/backend/notapproved/purchaseforma/{id}', [OrderController::class, 'showbackEndNotApprovedPurchaseFormA']);
Route::middleware('auth:sanctum')->get('/order/backend/notapproved/purchaseformb/{id}', [OrderController::class, 'showbackEndNotApprovedPurchaseFormB']);
Route::middleware('auth:sanctum')->get('/order/backend/notapproved/purchaseformc/{id}', [OrderController::class, 'showbackEndNotApprovedPurchaseFormC']);
Route::middleware('auth:sanctum')->get('/order/backend/notapproved/saleforma/{id}', [OrderController::class, 'showbackEndNotApprovedSaleFormA']);
Route::middleware('auth:sanctum')->get('/order/backend/notapproved/saleformb/{id}', [OrderController::class, 'showbackEndNotApprovedSaleFormB']);
Route::middleware('auth:sanctum')->get('/backend/dashboard/counter/approved', [DashboardController::class, 'BackendCounterApproved']);
Route::middleware('auth:sanctum')->get('/backend/dashboard/counter/pending', [DashboardController::class, 'BackendCounterPending']);
Route::middleware('auth:sanctum')->get('/backend/dashboard/counter/submitted', [DashboardController::class, 'BackendCounterSubmitted']);
Route::middleware('auth:sanctum')->get('/backend/dashboard/counter/notapproved', [DashboardController::class, 'BackendCounterNotApproved']);

// Notification
Route::middleware('auth:sanctum')->post('/notifications', [NotificationController::class, 'index']);
Route::middleware('auth:sanctum')->post('/notification/markasread', [NotificationController::class, 'markasread']);

// Fetch Reports
Route::middleware('auth:sanctum')->post('/report/records', [ReportController::class, 'Report']);

// Update Order By Custmoer
Route::middleware('auth:sanctum')->put('/customer/order/update/purchaseforma', [OrderController::class, 'updatePurchaseFormA']);
Route::middleware('auth:sanctum')->put('/customer/order/update/purchaseformb', [OrderController::class, 'updatePurchaseFormB']);
Route::middleware('auth:sanctum')->put('/customer/order/update/purchaseformc', [OrderController::class, 'updatePurchaseFormC']);
Route::middleware('auth:sanctum')->put('/customer/order/update/saleforma', [OrderController::class, 'updateSaleFormA']);
Route::middleware('auth:sanctum')->put('/customer/order/update/saleformb', [OrderController::class, 'updateSaleFormB']);
